/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.sindaryn.datafi.StaticUtils;
import org.sindaryn.datafi.annotations.NonCascadeUpdatable;
import org.sindaryn.datafi.annotations.NonCascadeUpdatables;
import org.sindaryn.datafi.annotations.NonNullable;
import org.sindaryn.datafi.reflection.CachedEntityField;

public class CachedEntityType {
    private Class<?> clazz;
    private Object defaultInstance;
    private Map<String, CachedEntityField> fields;
    private List<Field> cascadeUpdatableFields;
    private Map<String, Method> publicMethods;

    public CachedEntityType(Class<?> clazz, Collection<Field> fields, Collection<Method> publicMethods) {
        this.clazz = clazz;
        this.fields = new HashMap<String, CachedEntityField>();
        fields.forEach(field -> {
            boolean isCollectionOrMap = Iterable.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType());
            boolean isNonApiUpdatable = this.isNonApiUpdatable((Field)field);
            boolean isNonNullable = this.isNonNullableField((Field)field);
            this.fields.put(field.getName(), new CachedEntityField((Field)field, isCollectionOrMap, isNonApiUpdatable, isNonNullable));
        });
        this.publicMethods = new HashMap<String, Method>();
        publicMethods.forEach(publicMethod -> this.publicMethods.put(publicMethod.getName(), (Method)publicMethod));
        this.defaultInstance = CachedEntityType.genDefaultInstance(clazz);
        this.setCascadeUpdatableFields();
    }

    public Object invokeGetter(Object instance, String fieldName) {
        try {
            return this.publicMethods.get("get" + StaticUtils.toPascalCase(fieldName)).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invokeSetter(Object instance, String fieldName, Object value) {
        try {
            this.publicMethods.get("set" + StaticUtils.toPascalCase(fieldName)).invoke(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNonApiUpdatable(Field field) {
        return field.isAnnotationPresent(NonCascadeUpdatable.class) || this.isInNonCascadeUpdatables(field) || field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class) || Iterable.class.isAssignableFrom(field.getType()) || field.isAnnotationPresent(ElementCollection.class) || field.isAnnotationPresent(CollectionTable.class) || field.getType().equals(Map.class);
    }

    private boolean isInNonCascadeUpdatables(Field field) {
        NonCascadeUpdatables nonCascadeUpdatables = this.clazz.getAnnotation(NonCascadeUpdatables.class);
        if (nonCascadeUpdatables != null) {
            for (String fieldName : nonCascadeUpdatables.value()) {
                if (!fieldName.equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNonNullableField(Field field) {
        return field.isAnnotationPresent(NonNullable.class) || field.isAnnotationPresent(Column.class) && !field.getAnnotation(Column.class).nullable() || field.isAnnotationPresent(OneToOne.class) && !field.getAnnotation(OneToOne.class).optional() || field.isAnnotationPresent(ManyToOne.class) && !field.getAnnotation(ManyToOne.class).optional();
    }

    public static Object genDefaultInstance(Class<?> clazz) {
        Constructor<?>[] cons = clazz.getDeclaredConstructors();
        try {
            for (Constructor<?> constructor : cons) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("No default constructor found for " + clazz.getSimpleName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setCascadeUpdatableFields() {
        this.cascadeUpdatableFields = new ArrayList<Field>();
        this.fields.values().forEach(_field -> {
            if (!_field.isNonApiUpdatable()) {
                this.cascadeUpdatableFields.add(_field.getField());
            }
        });
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public Map<String, CachedEntityField> getFields() {
        return this.fields;
    }

    public List<Field> getCascadeUpdatableFields() {
        return this.cascadeUpdatableFields;
    }

    public Map<String, Method> getPublicMethods() {
        return this.publicMethods;
    }
}

