/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.entity;

import com.chad.library.adapter.base.entity.IExpandable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExpandableItem<T>
implements IExpandable<T> {
    protected boolean mExpandable = false;
    protected List<T> mSubItems;

    @Override
    public boolean isExpanded() {
        return this.mExpandable;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.mExpandable = expanded;
    }

    @Override
    public List<T> getSubItems() {
        return this.mSubItems;
    }

    public boolean hasSubItem() {
        return this.mSubItems != null && this.mSubItems.size() > 0;
    }

    public void setSubItems(List<T> list) {
        this.mSubItems = list;
    }

    public T getSubItem(int position) {
        if (this.hasSubItem() && position < this.mSubItems.size()) {
            return this.mSubItems.get(position);
        }
        return null;
    }

    public int getSubItemPosition(T subItem) {
        return this.mSubItems != null ? this.mSubItems.indexOf(subItem) : -1;
    }

    public void addSubItem(T subItem) {
        if (this.mSubItems == null) {
            this.mSubItems = new ArrayList<T>();
        }
        this.mSubItems.add(subItem);
    }

    public void addSubItem(int position, T subItem) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            this.mSubItems.add(position, subItem);
        } else {
            this.addSubItem(subItem);
        }
    }

    public boolean contains(T subItem) {
        return this.mSubItems != null && this.mSubItems.contains(subItem);
    }

    public boolean removeSubItem(T subItem) {
        return this.mSubItems != null && this.mSubItems.remove(subItem);
    }

    public boolean removeSubItem(int position) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            this.mSubItems.remove(position);
            return true;
        }
        return false;
    }
}

