/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.viewholder;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\u00032\b\b\u0001\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eJ\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u001a\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001e\u001a\u00020\u000eJ\u001a\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\"\u001a\u00020\u000eJ\u001a\u0010#\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eJ\u001a\u0010$\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010%\u001a\u00020\u000eJ\u0018\u0010&\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0016J\u0019\u0010(\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\u0003*\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/chad/library/adapter/base/viewholder/BaseViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "views", "Landroid/util/SparseArray;", "getBinding", "B", "Landroidx/databinding/ViewDataBinding;", "()Landroidx/databinding/ViewDataBinding;", "getView", "T", "viewId", "", "(I)Landroid/view/View;", "setBackgroundColor", "color", "setBackgroundResource", "backgroundRes", "setGone", "isGone", "", "setImageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageResource", "imageResId", "setText", "value", "", "strId", "setTextColor", "setTextColorRes", "colorRes", "setVisible", "isVisible", "findView", "library_release"})
public class BaseViewHolder
extends RecyclerView.ViewHolder {
    private final SparseArray<View> views;

    @Nullable
    public final <B extends ViewDataBinding> B getBinding() {
        return (B)DataBindingUtil.getBinding((View)this.itemView);
    }

    @NotNull
    public final <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        View view2 = view;
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)view2;
    }

    @NotNull
    public final <T extends View> T findView(int $this$findView) {
        View view = this.itemView.findViewById($this$findView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(this)");
        return (T)view;
    }

    @NotNull
    public final BaseViewHolder setText(@IdRes int viewId, @Nullable CharSequence value) {
        ((TextView)this.getView(viewId)).setText(value);
        return this;
    }

    @Nullable
    public final BaseViewHolder setText(@IdRes int viewId, @StringRes int strId) {
        ((TextView)this.getView(viewId)).setText(strId);
        return this;
    }

    @NotNull
    public final BaseViewHolder setTextColor(@IdRes int viewId, @ColorInt int color) {
        ((TextView)this.getView(viewId)).setTextColor(color);
        return this;
    }

    @NotNull
    public final BaseViewHolder setTextColorRes(@IdRes int viewId, @ColorRes int colorRes) {
        TextView textView = (TextView)this.getView(viewId);
        View view = this.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        textView.setTextColor(view.getResources().getColor(colorRes));
        return this;
    }

    @NotNull
    public final BaseViewHolder setImageResource(@IdRes int viewId, @DrawableRes int imageResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    @Nullable
    public final BaseViewHolder setImageDrawable(@IdRes int viewId, @Nullable Drawable drawable) {
        ((ImageView)this.getView(viewId)).setImageDrawable(drawable);
        return this;
    }

    @Nullable
    public final BaseViewHolder setImageBitmap(@IdRes int viewId, @Nullable Bitmap bitmap) {
        ((ImageView)this.getView(viewId)).setImageBitmap(bitmap);
        return this;
    }

    @Nullable
    public final BaseViewHolder setBackgroundColor(@IdRes int viewId, @ColorInt int color) {
        this.getView(viewId).setBackgroundColor(color);
        return this;
    }

    @Nullable
    public final BaseViewHolder setBackgroundResource(@IdRes int viewId, @DrawableRes int backgroundRes) {
        this.getView(viewId).setBackgroundResource(backgroundRes);
        return this;
    }

    @NotNull
    public final BaseViewHolder setVisible(@IdRes int viewId, boolean isVisible) {
        Object view = this.getView(viewId);
        view.setVisibility(isVisible ? 0 : 4);
        return this;
    }

    @NotNull
    public final BaseViewHolder setGone(@IdRes int viewId, boolean isGone) {
        Object view = this.getView(viewId);
        view.setVisibility(isGone ? 8 : 0);
        return this;
    }

    public BaseViewHolder(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super(view);
        this.views = new SparseArray();
    }
}

