/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.listener;

import android.os.Build;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import java.util.HashSet;
import java.util.Set;

public abstract class SimpleClickListener
implements RecyclerView.OnItemTouchListener {
    public static String TAG = "SimpleClickListener";
    private GestureDetectorCompat mGestureDetector;
    private RecyclerView recyclerView;
    protected BaseQuickAdapter baseQuickAdapter;
    private boolean mIsPrepressed = false;
    private boolean mIsShowPress = false;
    private View mPressedView = null;

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (this.recyclerView == null) {
            this.recyclerView = rv;
            this.baseQuickAdapter = (BaseQuickAdapter)this.recyclerView.getAdapter();
            this.mGestureDetector = new GestureDetectorCompat(this.recyclerView.getContext(), (GestureDetector.OnGestureListener)new ItemTouchHelperGestureListener(this.recyclerView));
        } else if (this.recyclerView != rv) {
            this.recyclerView = rv;
            this.baseQuickAdapter = (BaseQuickAdapter)this.recyclerView.getAdapter();
            this.mGestureDetector = new GestureDetectorCompat(this.recyclerView.getContext(), (GestureDetector.OnGestureListener)new ItemTouchHelperGestureListener(this.recyclerView));
        }
        if (!this.mGestureDetector.onTouchEvent(e) && e.getActionMasked() == 1 && this.mIsShowPress) {
            BaseViewHolder vh;
            if (!(this.mPressedView == null || (vh = (BaseViewHolder)this.recyclerView.getChildViewHolder(this.mPressedView)) != null && this.isHeaderOrFooterView(vh.getItemViewType()))) {
                this.mPressedView.setPressed(false);
            }
            this.mIsShowPress = false;
            this.mIsPrepressed = false;
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
        this.mGestureDetector.onTouchEvent(e);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void setPressViewHotSpot(MotionEvent e, View mPressedView) {
        if (Build.VERSION.SDK_INT >= 21 && mPressedView != null && mPressedView.getBackground() != null) {
            mPressedView.getBackground().setHotspot(e.getRawX(), e.getY() - mPressedView.getY());
        }
    }

    public abstract void onItemClick(BaseQuickAdapter var1, View var2, int var3);

    public abstract void onItemLongClick(BaseQuickAdapter var1, View var2, int var3);

    public abstract void onItemChildClick(BaseQuickAdapter var1, View var2, int var3);

    public abstract void onItemChildLongClick(BaseQuickAdapter var1, View var2, int var3);

    public boolean inRangeOfView(View view, MotionEvent ev) {
        int[] location = new int[2];
        if (view == null || !view.isShown()) {
            return false;
        }
        view.getLocationOnScreen(location);
        int x = location[0];
        int y = location[1];
        return !(ev.getRawX() < (float)x || ev.getRawX() > (float)(x + view.getWidth()) || ev.getRawY() < (float)y) && !(ev.getRawY() > (float)(y + view.getHeight()));
    }

    private boolean isHeaderOrFooterPosition(int position) {
        int type;
        if (this.baseQuickAdapter == null) {
            if (this.recyclerView != null) {
                this.baseQuickAdapter = (BaseQuickAdapter)this.recyclerView.getAdapter();
            } else {
                return false;
            }
        }
        return (type = this.baseQuickAdapter.getItemViewType(position)) == 1365 || type == 273 || type == 819 || type == 546;
    }

    private boolean isHeaderOrFooterView(int type) {
        return type == 1365 || type == 273 || type == 819 || type == 546;
    }

    private class ItemTouchHelperGestureListener
    implements GestureDetector.OnGestureListener {
        private RecyclerView recyclerView;

        public boolean onDown(MotionEvent e) {
            SimpleClickListener.this.mIsPrepressed = true;
            SimpleClickListener.this.mPressedView = this.recyclerView.findChildViewUnder(e.getX(), e.getY());
            return false;
        }

        public void onShowPress(MotionEvent e) {
            if (SimpleClickListener.this.mIsPrepressed && SimpleClickListener.this.mPressedView != null) {
                SimpleClickListener.this.mIsShowPress = true;
            }
        }

        ItemTouchHelperGestureListener(RecyclerView recyclerView) {
            this.recyclerView = recyclerView;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (SimpleClickListener.this.mIsPrepressed && SimpleClickListener.this.mPressedView != null) {
                if (this.recyclerView.getScrollState() != 0) {
                    return false;
                }
                View pressedView = SimpleClickListener.this.mPressedView;
                BaseViewHolder vh = (BaseViewHolder)this.recyclerView.getChildViewHolder(pressedView);
                int position = vh.getAdapterPosition();
                if (position == -1) {
                    return false;
                }
                if (SimpleClickListener.this.isHeaderOrFooterPosition(position)) {
                    return false;
                }
                position -= SimpleClickListener.this.baseQuickAdapter.getHeaderLayoutCount();
                HashSet<Integer> childClickViewIds = vh.getChildClickViewIds();
                Set<Integer> nestViewIds = vh.getNestViews();
                if (childClickViewIds != null && childClickViewIds.size() > 0) {
                    View childView;
                    for (Integer childClickViewId : childClickViewIds) {
                        childView = pressedView.findViewById(childClickViewId.intValue());
                        if (childView == null) continue;
                        if (SimpleClickListener.this.inRangeOfView(childView, e) && childView.isEnabled()) {
                            if (nestViewIds != null && nestViewIds.contains(childClickViewId)) {
                                return false;
                            }
                            SimpleClickListener.this.setPressViewHotSpot(e, childView);
                            childView.setPressed(true);
                            SimpleClickListener.this.onItemChildClick(SimpleClickListener.this.baseQuickAdapter, childView, position);
                            this.resetPressedView(childView);
                            return true;
                        }
                        childView.setPressed(false);
                    }
                    SimpleClickListener.this.setPressViewHotSpot(e, pressedView);
                    SimpleClickListener.this.mPressedView.setPressed(true);
                    for (Integer childClickViewId : childClickViewIds) {
                        childView = pressedView.findViewById(childClickViewId.intValue());
                        if (childView == null) continue;
                        childView.setPressed(false);
                    }
                    SimpleClickListener.this.onItemClick(SimpleClickListener.this.baseQuickAdapter, pressedView, position);
                } else {
                    SimpleClickListener.this.setPressViewHotSpot(e, pressedView);
                    SimpleClickListener.this.mPressedView.setPressed(true);
                    if (childClickViewIds != null && childClickViewIds.size() > 0) {
                        for (Integer childClickViewId : childClickViewIds) {
                            View childView = pressedView.findViewById(childClickViewId.intValue());
                            if (childView == null) continue;
                            childView.setPressed(false);
                        }
                    }
                    SimpleClickListener.this.onItemClick(SimpleClickListener.this.baseQuickAdapter, pressedView, position);
                }
                this.resetPressedView(pressedView);
            }
            return true;
        }

        private void resetPressedView(final View pressedView) {
            if (pressedView != null) {
                pressedView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (pressedView != null) {
                            pressedView.setPressed(false);
                        }
                    }
                }, 50L);
            }
            SimpleClickListener.this.mIsPrepressed = false;
            SimpleClickListener.this.mPressedView = null;
        }

        public void onLongPress(MotionEvent e) {
            boolean isChildLongClick = false;
            if (this.recyclerView.getScrollState() != 0) {
                return;
            }
            if (SimpleClickListener.this.mIsPrepressed && SimpleClickListener.this.mPressedView != null) {
                SimpleClickListener.this.mPressedView.performHapticFeedback(0);
                BaseViewHolder vh = (BaseViewHolder)this.recyclerView.getChildViewHolder(SimpleClickListener.this.mPressedView);
                int position = vh.getAdapterPosition();
                if (position == -1) {
                    return;
                }
                if (!SimpleClickListener.this.isHeaderOrFooterPosition(position)) {
                    View childView;
                    HashSet<Integer> longClickViewIds = vh.getItemChildLongClickViewIds();
                    Set<Integer> nestViewIds = vh.getNestViews();
                    if (longClickViewIds != null && longClickViewIds.size() > 0) {
                        for (Integer longClickViewId : longClickViewIds) {
                            childView = SimpleClickListener.this.mPressedView.findViewById(longClickViewId.intValue());
                            if (!SimpleClickListener.this.inRangeOfView(childView, e) || !childView.isEnabled()) continue;
                            if (nestViewIds != null && nestViewIds.contains(longClickViewId)) {
                                isChildLongClick = true;
                                break;
                            }
                            SimpleClickListener.this.setPressViewHotSpot(e, childView);
                            SimpleClickListener.this.onItemChildLongClick(SimpleClickListener.this.baseQuickAdapter, childView, position - SimpleClickListener.this.baseQuickAdapter.getHeaderLayoutCount());
                            childView.setPressed(true);
                            SimpleClickListener.this.mIsShowPress = true;
                            isChildLongClick = true;
                            break;
                        }
                    }
                    if (!isChildLongClick) {
                        SimpleClickListener.this.onItemLongClick(SimpleClickListener.this.baseQuickAdapter, SimpleClickListener.this.mPressedView, position - SimpleClickListener.this.baseQuickAdapter.getHeaderLayoutCount());
                        SimpleClickListener.this.setPressViewHotSpot(e, SimpleClickListener.this.mPressedView);
                        SimpleClickListener.this.mPressedView.setPressed(true);
                        if (longClickViewIds != null) {
                            for (Integer longClickViewId : longClickViewIds) {
                                childView = SimpleClickListener.this.mPressedView.findViewById(longClickViewId.intValue());
                                if (childView == null) continue;
                                childView.setPressed(false);
                            }
                        }
                        SimpleClickListener.this.mIsShowPress = true;
                    }
                }
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    }
}

