/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.MotionEvent;
import android.view.View;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.listener.IDraggableListener;
import com.chad.library.adapter.base.listener.OnItemDragListener;
import com.chad.library.adapter.base.listener.OnItemSwipeListener;
import java.util.Collections;

public class DraggableController
implements IDraggableListener {
    private static final int NO_TOGGLE_VIEW = 0;
    private int mToggleViewId = 0;
    private ItemTouchHelper mItemTouchHelper;
    private boolean itemDragEnabled = false;
    private boolean itemSwipeEnabled = false;
    private OnItemDragListener mOnItemDragListener;
    private OnItemSwipeListener mOnItemSwipeListener;
    private boolean mDragOnLongPress = true;
    private View.OnTouchListener mOnToggleViewTouchListener;
    private View.OnLongClickListener mOnToggleViewLongClickListener;
    private BaseQuickAdapter mAdapter;

    public DraggableController(BaseQuickAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void initView(BaseViewHolder holder) {
        Object toggleView;
        int viewType = holder.getItemViewType();
        if (this.mItemTouchHelper != null && this.itemDragEnabled && viewType != 546 && viewType != 273 && viewType != 1365 && viewType != 819 && this.hasToggleView() && (toggleView = holder.getView(this.mToggleViewId)) != null) {
            toggleView.setTag(R.id.BaseQuickAdapter_viewholder_support, (Object)holder);
            if (this.mDragOnLongPress) {
                toggleView.setOnLongClickListener(this.mOnToggleViewLongClickListener);
            } else {
                toggleView.setOnTouchListener(this.mOnToggleViewTouchListener);
            }
        }
    }

    public void setToggleViewId(int toggleViewId) {
        this.mToggleViewId = toggleViewId;
    }

    public void setToggleDragOnLongPress(boolean longPress) {
        this.mDragOnLongPress = longPress;
        if (this.mDragOnLongPress) {
            this.mOnToggleViewTouchListener = null;
            this.mOnToggleViewLongClickListener = new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (DraggableController.this.mItemTouchHelper != null && DraggableController.this.itemDragEnabled) {
                        DraggableController.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                    }
                    return true;
                }
            };
        } else {
            this.mOnToggleViewTouchListener = new View.OnTouchListener(){

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View v, MotionEvent event) {
                    if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && !DraggableController.this.mDragOnLongPress) {
                        if (DraggableController.this.mItemTouchHelper != null && DraggableController.this.itemDragEnabled) {
                            DraggableController.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.mOnToggleViewLongClickListener = null;
        }
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper) {
        this.enableDragItem(itemTouchHelper, 0, true);
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper, int toggleViewId) {
        this.enableDragItem(itemTouchHelper, toggleViewId, true);
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper, int toggleViewId, boolean dragOnLongPress) {
        this.itemDragEnabled = true;
        this.mItemTouchHelper = itemTouchHelper;
        this.setToggleViewId(toggleViewId);
        this.setToggleDragOnLongPress(dragOnLongPress);
    }

    public void disableDragItem() {
        this.itemDragEnabled = false;
        this.mItemTouchHelper = null;
    }

    @Override
    public boolean isItemDraggable() {
        return this.itemDragEnabled;
    }

    @Override
    public boolean hasToggleView() {
        return this.mToggleViewId != 0;
    }

    public void enableSwipeItem() {
        this.itemSwipeEnabled = true;
    }

    public void disableSwipeItem() {
        this.itemSwipeEnabled = false;
    }

    @Override
    public boolean isItemSwipeEnable() {
        return this.itemSwipeEnabled;
    }

    public void setOnItemDragListener(OnItemDragListener onItemDragListener) {
        this.mOnItemDragListener = onItemDragListener;
    }

    public int getViewHolderPosition(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition() - this.mAdapter.getHeaderLayoutCount();
    }

    @Override
    public void onItemDragStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    @Override
    public void onItemDragMoving(RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        int from = this.getViewHolderPosition(source);
        int to = this.getViewHolderPosition(target);
        if (this.inRange(from) && this.inRange(to)) {
            if (from < to) {
                for (int i = from; i < to; ++i) {
                    Collections.swap(this.mAdapter.getData(), i, i + 1);
                }
            } else {
                for (int i = from; i > to; --i) {
                    Collections.swap(this.mAdapter.getData(), i, i - 1);
                }
            }
            this.mAdapter.notifyItemMoved(source.getAdapterPosition(), target.getAdapterPosition());
        }
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragMoving(source, from, target, to);
        }
    }

    @Override
    public void onItemDragEnd(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragEnd(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void setOnItemSwipeListener(OnItemSwipeListener listener) {
        this.mOnItemSwipeListener = listener;
    }

    @Override
    public void onItemSwipeStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    @Override
    public void onItemSwipeClear(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.clearView(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    @Override
    public void onItemSwiped(RecyclerView.ViewHolder viewHolder) {
        int pos;
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwiped(viewHolder, this.getViewHolderPosition(viewHolder));
        }
        if (this.inRange(pos = this.getViewHolderPosition(viewHolder))) {
            this.mAdapter.getData().remove(pos);
            this.mAdapter.notifyItemRemoved(viewHolder.getAdapterPosition());
        }
    }

    @Override
    public void onItemSwiping(Canvas canvas, RecyclerView.ViewHolder viewHolder, float x, float y, boolean isCurrentlyActive) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeMoving(canvas, viewHolder, x, y, isCurrentlyActive);
        }
    }

    private boolean inRange(int position) {
        return position >= 0 && position < this.mAdapter.getData().size();
    }
}

