/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.util.SparseIntArray;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.IExpandable;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import java.util.List;

public abstract class BaseMultiItemQuickAdapter<T extends MultiItemEntity, K extends BaseViewHolder>
extends BaseQuickAdapter<T, K> {
    private SparseIntArray layouts;
    private static final int DEFAULT_VIEW_TYPE = -255;
    public static final int TYPE_NOT_FOUND = -404;

    public BaseMultiItemQuickAdapter(List<T> data) {
        super(data);
    }

    @Override
    protected int getDefItemViewType(int position) {
        Object item = this.mData.get(position);
        if (item instanceof MultiItemEntity) {
            return ((MultiItemEntity)item).getItemType();
        }
        return -255;
    }

    protected void setDefaultViewTypeLayout(@LayoutRes int layoutResId) {
        this.addItemType(-255, layoutResId);
    }

    @Override
    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.getLayoutId(viewType));
    }

    private int getLayoutId(int viewType) {
        return this.layouts.get(viewType, -404);
    }

    protected void addItemType(int type, @LayoutRes int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseIntArray();
        }
        this.layouts.put(type, layoutResId);
    }

    @Override
    public void remove(@IntRange(from=0L) int position) {
        if (this.mData == null || position < 0 || position >= this.mData.size()) {
            return;
        }
        MultiItemEntity entity = (MultiItemEntity)this.mData.get(position);
        if (entity instanceof IExpandable) {
            this.removeAllChild((IExpandable)((Object)entity), position);
        }
        this.removeDataFromParent(entity);
        super.remove(position);
    }

    protected void removeAllChild(IExpandable parent, int parentPosition) {
        if (parent.isExpanded()) {
            List chidChilds = parent.getSubItems();
            if (chidChilds == null || chidChilds.size() == 0) {
                return;
            }
            int childSize = chidChilds.size();
            for (int i = 0; i < childSize; ++i) {
                this.remove(parentPosition + 1);
            }
        }
    }

    protected void removeDataFromParent(T child) {
        int position = this.getParentPosition(child);
        if (position >= 0) {
            IExpandable parent = (IExpandable)this.mData.get(position);
            parent.getSubItems().remove(child);
        }
    }
}

