/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.callback;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import com.chad.library.adapter.base.BaseQuickAdapter;

public class ItemDragAndSwipeCallback
extends ItemTouchHelper.Callback {
    private BaseQuickAdapter mAdapter;
    private static final float THRESHOLD_SWIPE = 0.7f;
    private static final float THRESHOLD_MOVE = 0.1f;
    private int mActionState = 0;

    public ItemDragAndSwipeCallback(BaseQuickAdapter adapter) {
        this.mAdapter = adapter;
    }

    public boolean isLongPressDragEnabled() {
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.mAdapter.isItemSwipeEnable();
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState == 2) {
            this.mAdapter.onItemDragStart(viewHolder);
            this.mActionState = actionState;
        } else if (actionState == 1) {
            this.mAdapter.onItemSwipeStart(viewHolder);
            this.mActionState = actionState;
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (this.mActionState == 2) {
            this.mAdapter.onItemDragEnd(viewHolder);
        } else if (this.mActionState == 1) {
            this.mAdapter.onItemSwipeClear(viewHolder);
        }
        this.mActionState = 0;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        int dragFlags = 15;
        int swipeFlags = 32;
        return ItemDragAndSwipeCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        return source.getItemViewType() == target.getItemViewType();
    }

    public void onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder source, int fromPos, RecyclerView.ViewHolder target, int toPos, int x, int y) {
        this.mAdapter.onItemDragMoving(source, target);
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        this.mAdapter.onItemSwiped(viewHolder);
    }

    public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
        return 0.1f;
    }

    public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
        return 0.7f;
    }
}

