/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMultiItemQuickAdapter<T extends MultiItemEntity>
extends BaseQuickAdapter {
    protected List<T> mData;
    private SparseArray<Integer> layouts;

    public BaseMultiItemQuickAdapter(Context context, List<T> data) {
        super(context, data);
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
    }

    @Override
    protected int getDefItemViewType(int position) {
        return ((MultiItemEntity)this.mData.get(position)).getItemType();
    }

    @Override
    protected BaseViewHolder onCreateDefViewHolder(ViewGroup parent, int viewType) {
        int layoutId = this.getLayoutId(viewType);
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        return new BaseViewHolder(this.mContext, view);
    }

    private int getLayoutId(int viewType) {
        return (Integer)this.layouts.get(viewType);
    }

    protected void addItmeType(int type, int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseArray();
        }
        this.layouts.put(type, (Object)layoutResId);
    }

    protected void convert(BaseViewHolder helper, Object item) {
        this.convert(helper, (T)((MultiItemEntity)item));
    }

    @Override
    protected abstract void convert(BaseViewHolder var1, T var2);
}

