/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.net.Uri;
import android.text.TextUtils;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.File;

public class StringLoader<T>
implements ModelLoader<String, T> {
    private final ModelLoader<Uri, T> uriLoader;

    public StringLoader(ModelLoader<Uri, T> uriLoader) {
        this.uriLoader = uriLoader;
    }

    @Override
    public DataFetcher<T> getResourceFetcher(String model, int width, int height) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return null;
        }
        if (model.startsWith("/")) {
            uri = StringLoader.toFileUri(model);
        } else {
            uri = Uri.parse((String)model);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = StringLoader.toFileUri(model);
            }
        }
        return this.uriLoader.getResourceFetcher(uri, width, height);
    }

    private static Uri toFileUri(String path) {
        return Uri.fromFile((File)new File(path));
    }
}

