/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected final Context context;
    protected final int layoutResId;
    protected final List<T> data;
    private OnRecyclerViewItemClickListener onRecyclerViewItemClickListener;

    public void setOnRecyclerViewItemClickListener(OnRecyclerViewItemClickListener onRecyclerViewItemClickListener) {
        this.onRecyclerViewItemClickListener = onRecyclerViewItemClickListener;
    }

    public BaseQuickAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public BaseQuickAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public void remove(int position) {
        this.data.remove(position);
        this.notifyItemRemoved(position);
    }

    public void add(int position, T item) {
        this.data.add(position, item);
        this.notifyItemInserted(position);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View item = LayoutInflater.from((Context)parent.getContext()).inflate(this.layoutResId, parent, false);
        return new BaseViewHolder(this.context, item);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        BaseViewHolder baseViewHolder = (BaseViewHolder)holder;
        this.convert(baseViewHolder, this.data.get(position));
        if (this.onRecyclerViewItemClickListener != null) {
            baseViewHolder.getView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseQuickAdapter.this.onRecyclerViewItemClickListener.onItemClick(v, position);
                }
            });
        }
    }

    protected abstract void convert(BaseViewHolder var1, T var2);

    public long getItemId(int position) {
        return position;
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

