/*
 * Decompiled with CFR 0.152.
 */
package com.cunoraz.gifview.library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import com.cunoraz.gifview.library.R;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 ;2\u00020\u0001:\u0001;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020#H\u0003J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J0\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0014J\u0018\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0014J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0007H\u0017J\u0018\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0007H\u0015J\u0010\u00106\u001a\u00020#2\u0006\u00105\u001a\u00020\u0007H\u0014J\u0006\u00107\u001a\u00020#J\u0006\u00108\u001a\u00020#J\"\u00109\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\b\u0010:\u001a\u00020#H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/cunoraz/gifview/library/GifView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentAnimationTime", "movieResourceId", "gifResource", "getGifResource", "()I", "setGifResource", "(I)V", "isPaused", "", "()Z", "setPaused", "(Z)V", "isPlaying", "isVisible", "movie", "Landroid/graphics/Movie;", "movieLeft", "", "movieMeasuredMovieHeight", "movieMeasuredMovieWidth", "movieMovieResourceId", "movieScale", "movieStart", "", "movieTop", "drawMovieFrame", "", "canvas", "Landroid/graphics/Canvas;", "invalidateView", "onDraw", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScreenStateChanged", "screenState", "onVisibilityChanged", "changedView", "visibility", "onWindowVisibilityChanged", "pause", "play", "setViewAttributes", "updateAnimationTime", "Companion", "library_release"})
public final class GifView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int movieMovieResourceId;
    @Nullable
    private Movie movie;
    private long movieStart;
    private int currentAnimationTime;
    private float movieLeft;
    private float movieTop;
    private float movieScale;
    private int movieMeasuredMovieWidth;
    private int movieMeasuredMovieHeight;
    private volatile boolean isPaused;
    private boolean isVisible;
    private static final int DEFAULT_MOVIE_VIEW_DURATION = 1000;

    @JvmOverloads
    public GifView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.isVisible = true;
        this.setViewAttributes(context, attrs, defStyle);
    }

    public /* synthetic */ GifView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.styleable.CustomTheme_gifViewStyle;
        }
        this(context, attributeSet, n);
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public final int getGifResource() {
        return this.movieMovieResourceId;
    }

    public final void setGifResource(int movieResourceId) {
        this.movieMovieResourceId = movieResourceId;
        this.movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.movieMovieResourceId));
        this.requestLayout();
    }

    public final boolean isPlaying() {
        return !this.isPaused;
    }

    @SuppressLint(value={"NewApi"})
    private final void setViewAttributes(Context context, AttributeSet attrs, int defStyle) {
        this.setLayerType(1, null);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GifView, defStyle, R.style.Widget_GifView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026.Widget_GifView\n        )");
        TypedArray array = typedArray;
        this.movieMovieResourceId = array.getResourceId(R.styleable.GifView_gif, -1);
        this.isPaused = array.getBoolean(R.styleable.GifView_paused, false);
        array.recycle();
        if (this.movieMovieResourceId != -1) {
            this.movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.movieMovieResourceId));
        }
    }

    public final void play() {
        if (this.isPaused) {
            this.isPaused = false;
            this.movieStart = SystemClock.uptimeMillis() - (long)this.currentAnimationTime;
            this.invalidate();
        }
    }

    public final void pause() {
        if (!this.isPaused) {
            this.isPaused = true;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.movie != null) {
            int maximumHeight;
            int maximumWidth;
            Movie movie = this.movie;
            Intrinsics.checkNotNull((Object)movie);
            int movieWidth = movie.width();
            Movie movie2 = this.movie;
            Intrinsics.checkNotNull((Object)movie2);
            int movieHeight = movie2.height();
            float scaleH = 1.0f;
            int measureModeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (measureModeWidth != 0 && movieWidth > (maximumWidth = View.MeasureSpec.getSize((int)widthMeasureSpec))) {
                scaleH = (float)movieWidth / (float)maximumWidth;
            }
            float scaleW = 1.0f;
            int measureModeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (measureModeHeight != 0 && movieHeight > (maximumHeight = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                scaleW = (float)movieHeight / (float)maximumHeight;
            }
            this.movieScale = 1.0f / RangesKt.coerceAtLeast((float)scaleH, (float)scaleW);
            this.movieMeasuredMovieWidth = (int)((float)movieWidth * this.movieScale);
            this.movieMeasuredMovieHeight = (int)((float)movieHeight * this.movieScale);
            this.setMeasuredDimension(this.movieMeasuredMovieWidth, this.movieMeasuredMovieHeight);
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.movieLeft = (float)(this.getWidth() - this.movieMeasuredMovieWidth) / 2.0f;
        this.movieTop = (float)(this.getHeight() - this.movieMeasuredMovieHeight) / 2.0f;
        this.isVisible = this.getVisibility() == 0;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.movie != null) {
            if (!this.isPaused) {
                this.updateAnimationTime();
                this.drawMovieFrame(canvas);
                this.invalidateView();
            } else {
                this.drawMovieFrame(canvas);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private final void invalidateView() {
        if (this.isVisible) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    private final void updateAnimationTime() {
        long now = SystemClock.uptimeMillis();
        if (this.movieStart == 0L) {
            this.movieStart = now;
        }
        Movie movie = this.movie;
        Intrinsics.checkNotNull((Object)movie);
        int duration = movie.duration();
        if (duration == 0) {
            duration = 1000;
        }
        this.currentAnimationTime = (int)((now - this.movieStart) % (long)duration);
    }

    private final void drawMovieFrame(Canvas canvas) {
        Movie movie = this.movie;
        Intrinsics.checkNotNull((Object)movie);
        movie.setTime(this.currentAnimationTime);
        canvas.save();
        canvas.scale(this.movieScale, this.movieScale);
        Movie movie2 = this.movie;
        Intrinsics.checkNotNull((Object)movie2);
        movie2.draw(canvas, this.movieLeft / this.movieScale, this.movieTop / this.movieScale);
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        this.isVisible = screenState == 1;
        this.invalidateView();
    }

    @SuppressLint(value={"NewApi"})
    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        this.isVisible = visibility == 0;
        this.invalidateView();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.isVisible = visibility == 0;
        this.invalidateView();
    }

    @JvmOverloads
    public GifView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GifView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cunoraz/gifview/library/GifView$Companion;", "", "()V", "DEFAULT_MOVIE_VIEW_DURATION", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

