/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc.introspection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.consensusj.jsonrpc.JsonRpcError;
import org.consensusj.jsonrpc.JsonRpcErrorException;
import org.consensusj.jsonrpc.JsonRpcRequest;
import org.consensusj.jsonrpc.JsonRpcResponse;
import org.consensusj.jsonrpc.JsonRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JsonRpcServiceWrapper
extends JsonRpcService {
    public static final Logger log = LoggerFactory.getLogger(JsonRpcServiceWrapper.class);

    public Object getServiceObject();

    public Method getMethod(String var1);

    default public <R> CompletableFuture<JsonRpcResponse<R>> call(JsonRpcRequest req) {
        log.debug("JsonRpcServiceWrapper.call: {}", (Object)req.getMethod());
        CompletableFuture<R> result = this.callMethod(req.getMethod(), req.getParams());
        return result.handle((r, ex) -> this.resultCompletionHandler(req, (Object)r, (Throwable)ex));
    }

    default public <T> JsonRpcResponse<T> resultCompletionHandler(JsonRpcRequest req, T result, Throwable ex) {
        return result != null ? JsonRpcServiceWrapper.wrapResult(req, result) : JsonRpcServiceWrapper.wrapError(req, this.exceptionToError(ex));
    }

    default public JsonRpcError exceptionToError(Throwable ex) {
        return ex instanceof JsonRpcErrorException ? ((JsonRpcErrorException)ex).getError() : JsonRpcError.of(JsonRpcError.Error.SERVER_EXCEPTION);
    }

    default public <R> CompletableFuture<R> callMethod(String methodName, List<Object> params) {
        log.debug("JsonRpcServiceWrapper.callMethod: {}", (Object)methodName);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Method mh = this.getMethod(methodName);
        if (mh != null) {
            try {
                Object result = mh.invoke(this.getServiceObject(), params.toArray());
                future.complete(result);
            }
            catch (Throwable throwable) {
                log.error("Exception in invoked service object: ", throwable);
                JsonRpcErrorException jsonRpcException = new JsonRpcErrorException(JsonRpcError.Error.SERVER_EXCEPTION, throwable);
                future.completeExceptionally(jsonRpcException);
            }
        } else {
            future.completeExceptionally(JsonRpcErrorException.of(JsonRpcError.Error.METHOD_NOT_FOUND));
        }
        return future;
    }

    public static Map<String, Method> reflect(Class<?> apiClass) {
        Method[] publicInheritedMethods = apiClass.getMethods();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : publicInheritedMethods) {
            String name = method.getName();
            methods.put(name, method);
        }
        return methods;
    }

    public static <T> JsonRpcResponse<T> wrapResult(JsonRpcRequest req, T result) {
        return new JsonRpcResponse<T>(req, result);
    }

    public static <T> JsonRpcResponse<T> wrapError(JsonRpcRequest req, JsonRpcError error) {
        return new JsonRpcResponse(req, error);
    }
}

