/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.consensusj.jsonrpc.JsonRpcMessage;
import org.consensusj.jsonrpc.internal.NumberStringSerializer;

public class JsonRpcRequest {
    @Deprecated
    public static final String JSON_RPC_VERSION_1 = JsonRpcMessage.Version.V1.jsonrpc();
    @Deprecated
    public static final String JSON_RPC_VERSION_2 = JsonRpcMessage.Version.V2.jsonrpc();
    private static final JsonRpcMessage.Version DEFAULT_JSON_RPC_VERSION = JsonRpcMessage.Version.V2;
    private static final AtomicLong nextRequestId = new AtomicLong(0L);
    private final String method;
    private final List<Object> params;
    private final String jsonrpc;
    private final String id;

    @JsonCreator
    public JsonRpcRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") String id, @JsonProperty(value="method") String method, @JsonProperty(value="params") List<Object> params) {
        this.jsonrpc = jsonrpc;
        this.method = method;
        this.id = id;
        this.params = params;
    }

    public JsonRpcRequest(JsonRpcMessage.Version jsonRpcVersion, long id, String method, List<Object> params) {
        this.jsonrpc = jsonRpcVersion.jsonrpc();
        this.method = method;
        this.id = Long.toString(id);
        this.params = params;
    }

    public JsonRpcRequest(JsonRpcMessage.Version jsonRpcVersion, String method, List<Object> params) {
        this(jsonRpcVersion, nextRequestId.incrementAndGet(), method, JsonRpcRequest.removeTrailingNulls(params));
    }

    public JsonRpcRequest(String method, List<Object> params) {
        this(DEFAULT_JSON_RPC_VERSION, method, params);
    }

    @Deprecated
    public JsonRpcRequest(String method, List<Object> params, String jsonRpcVersionString) {
        this(jsonRpcVersionString, Long.toString(nextRequestId.incrementAndGet()), method, JsonRpcRequest.removeTrailingNulls(params));
    }

    public JsonRpcRequest(String method) {
        this(method, Collections.emptyList());
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    @JsonSerialize(using=NumberStringSerializer.class)
    public String getId() {
        return this.id;
    }

    public List<Object> getParams() {
        return this.params;
    }

    private static List<Object> removeTrailingNulls(List<Object> params) {
        LinkedList<Object> cleaned = new LinkedList<Object>(params);
        while (cleaned.size() > 0 && cleaned.getLast() == null) {
            cleaned.removeLast();
        }
        return cleaned;
    }
}

