/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.consensusj.jsonrpc.AsyncSupport;
import org.consensusj.jsonrpc.JsonRpcMessage;
import org.consensusj.jsonrpc.JsonRpcRequest;
import org.consensusj.jsonrpc.JsonRpcStatusException;

public interface JsonRpcClient
extends AutoCloseable,
AsyncSupport {
    public JsonRpcMessage.Version getJsonRpcVersion();

    public URI getServerURI();

    public <R> R send(String var1, List<Object> var2) throws IOException, JsonRpcStatusException;

    default public <R> R send(String method, Object ... params) throws IOException, JsonRpcStatusException {
        return this.send(method, Arrays.asList(params));
    }

    public <R> R send(String var1, Class<R> var2, List<Object> var3) throws IOException, JsonRpcStatusException;

    default public <R> R send(String method, Class<R> resultType, Object ... params) throws IOException, JsonRpcStatusException {
        return this.send(method, resultType, Arrays.asList(params));
    }

    default public JsonRpcRequest buildJsonRequest(String method, List<Object> params) {
        return new JsonRpcRequest(this.getJsonRpcVersion(), method, params);
    }

    default public JsonRpcRequest buildJsonRequest(String method, Object ... params) {
        return new JsonRpcRequest(this.getJsonRpcVersion(), method, Arrays.asList(params));
    }

    @Override
    default public void close() throws Exception {
    }
}

