/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTrustManager
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(CompositeTrustManager.class);
    private static final char[] password = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private final List<X509TrustManager> trustManagerList;

    public CompositeTrustManager(InputStream trustStoreStream) {
        ArrayList<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();
        try {
            trustManagers.add(CompositeTrustManager.getCustomTrustManager(trustStoreStream));
            trustManagers.add(CompositeTrustManager.getDefaultTrustManager());
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                trustStoreStream.close();
            }
            catch (IOException e) {
                log.error("Exception: ", (Throwable)e);
            }
        }
        this.trustManagerList = trustManagers;
    }

    public CompositeTrustManager(Path trustStorePath) throws FileNotFoundException {
        this(new FileInputStream(trustStorePath.toFile()));
    }

    public static SSLSocketFactory getCompositeSSLSocketFactory(Path trustStorePath) throws NoSuchAlgorithmException, KeyManagementException, FileNotFoundException {
        CompositeTrustManager tm = new CompositeTrustManager(trustStorePath);
        return CompositeTrustManager.getSocketFactory(tm);
    }

    public static SSLSocketFactory getCompositeSSLSocketFactory(InputStream trustStoreStream) throws NoSuchAlgorithmException, KeyManagementException {
        CompositeTrustManager tm = new CompositeTrustManager(trustStoreStream);
        return CompositeTrustManager.getSocketFactory(tm);
    }

    public static SSLSocketFactory getAlternateSSLSocketFactory(Path trustStorePath) throws KeyStoreException, IOException, NoSuchAlgorithmException, KeyManagementException, CertificateException {
        return CompositeTrustManager.getAlternateSSLSocketFactory(new FileInputStream(trustStorePath.toFile()));
    }

    public static SSLSocketFactory getAlternateSSLSocketFactory(InputStream trustStoreStream) throws KeyStoreException, IOException, NoSuchAlgorithmException, KeyManagementException, CertificateException {
        X509TrustManager trustManager = CompositeTrustManager.getCustomTrustManager(trustStoreStream);
        return CompositeTrustManager.getSocketFactory(trustManager);
    }

    private static SSLSocketFactory getSocketFactory(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{trustManager}, null);
        return ctx.getSocketFactory();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagerList) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagerList) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagerList) {
            certs.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return certs.toArray(new X509Certificate[0]);
    }

    private static X509TrustManager getCustomTrustManager(InputStream trustStream) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return CompositeTrustManager.createTrustManager(trustStream);
    }

    private static X509TrustManager getDefaultTrustManager() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return CompositeTrustManager.createTrustManager(null);
    }

    private static X509TrustManager createTrustManager(InputStream trustStream) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManager[] trustManagers;
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(trustStream, password);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        for (TrustManager trustManager : trustManagers = trustFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new CertificateException("No X509TrustManager available");
    }
}

