/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public interface AsyncSupport {
    default public <T> CompletableFuture<T> supplyAsync(ThrowingSupplier<T> throwingSupplier) {
        return this.supplyAsync(throwingSupplier, this.getDefaultAsyncExecutor());
    }

    default public <T> CompletableFuture<T> supplyAsync(ThrowingSupplier<T> throwingSupplier, Executor executor) {
        return AsyncSupport.supplyCatchingAsync(throwingSupplier, executor);
    }

    default public Executor getDefaultAsyncExecutor() {
        return r -> new Thread(r).start();
    }

    public static <T> CompletableFuture<T> supplyCatchingAsync(ThrowingSupplier<T> throwingSupplier, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                Object result = throwingSupplier.getThrows();
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        @Override
        default public T get() {
            try {
                return this.getThrows();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public T getThrows() throws Exception;
    }
}

