/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.msgilligan.bitcoinj.json.conversion.HexUtil;
import java.util.ArrayList;
import java.util.List;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RawTransactionInfo {
    public final String hex;
    public final Sha256Hash txid;
    public final long version;
    public final long locktime;
    public final VinList vin;
    public final VoutList vout;
    public final Sha256Hash blockhash;
    public final int confirmations;
    public final long time;
    public final long blocktime;

    @JsonCreator
    public RawTransactionInfo(@JsonProperty(value="hex") String hex, @JsonProperty(value="txid") Sha256Hash txid, @JsonProperty(value="version") long version, @JsonProperty(value="locktime") long locktime, @JsonProperty(value="vin") VinList vin, @JsonProperty(value="vout") VoutList vout, @JsonProperty(value="blockhash") Sha256Hash blockhash, @JsonProperty(value="confirmations") int confirmations, @JsonProperty(value="time") long time, @JsonProperty(value="blocktime") long blocktime) {
        this.hex = hex;
        this.txid = txid;
        this.version = version;
        this.locktime = locktime;
        this.vin = vin;
        this.vout = vout;
        this.blockhash = blockhash;
        this.confirmations = confirmations;
        this.time = time;
        this.blocktime = blocktime;
    }

    public RawTransactionInfo(Transaction transaction) {
        this.hex = HexUtil.bytesToHexString(transaction.bitcoinSerialize());
        this.txid = transaction.getTxId();
        this.version = transaction.getVersion();
        this.locktime = transaction.getLockTime();
        this.blockhash = null;
        this.confirmations = transaction.getConfidence().getDepthInBlocks();
        this.blocktime = this.time = 0L;
        this.vin = new VinList();
        for (TransactionInput input : transaction.getInputs()) {
            this.vin.add(new Vin(this.txid, input.getOutpoint().getIndex(), input.getScriptSig().toString(), input.getSequenceNumber()));
        }
        this.vout = new VoutList();
        for (TransactionOutput output : transaction.getOutputs()) {
            this.vout.add(new Vout(output.getValue(), output.getIndex(), output.getScriptPubKey().toString()));
        }
    }

    public String getHex() {
        return this.hex;
    }

    public Sha256Hash getTxid() {
        return this.txid;
    }

    public long getVersion() {
        return this.version;
    }

    public long getLocktime() {
        return this.locktime;
    }

    public List<Vin> getVin() {
        return this.vin;
    }

    public List<Vout> getVout() {
        return this.vout;
    }

    public Sha256Hash getBlockhash() {
        return this.blockhash;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public long getTime() {
        return this.time;
    }

    public long getBlocktime() {
        return this.blocktime;
    }

    public static class Vout {
        public final Coin value;
        public final int n;
        public final Object scriptPubKey;

        public Vout(@JsonProperty(value="value") Coin value, @JsonProperty(value="n") int n, @JsonProperty(value="scriptPubKey") Object scriptPubKey) {
            this.value = value;
            this.n = n;
            this.scriptPubKey = scriptPubKey;
        }

        public Coin getValue() {
            return this.value;
        }

        public int getN() {
            return this.n;
        }

        public Object getScriptPubKey() {
            return this.scriptPubKey;
        }
    }

    public static class Vin {
        public final Sha256Hash txid;
        public final long vout;
        public final Object scriptSig;
        public final long sequence;

        public Vin(@JsonProperty(value="txid") Sha256Hash txid, @JsonProperty(value="vout") long vout, @JsonProperty(value="scriptSig") Object scriptSig, @JsonProperty(value="sequence") long sequence) {
            this.txid = txid;
            this.vout = vout;
            this.scriptSig = scriptSig;
            this.sequence = sequence;
        }

        public Sha256Hash getTxid() {
            return this.txid;
        }

        public long getVout() {
            return this.vout;
        }

        public Object getScriptSig() {
            return this.scriptSig;
        }

        public long getSequence() {
            return this.sequence;
        }
    }

    public static class VoutList
    extends ArrayList<Vout> {
    }

    public static class VinList
    extends ArrayList<Vin> {
    }
}

