/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AddressGroupingItem {
    private final Address address;
    private final Coin balance;
    private final String account;

    public AddressGroupingItem(Address address, Coin balance, String account) {
        this.address = address;
        this.balance = balance;
        this.account = account;
    }

    public AddressGroupingItem(List<Object> addressItem, NetworkParameters netParams) {
        String addressStr = (String)addressItem.get(0);
        Double balanceDouble = (Double)addressItem.get(1);
        this.account = addressItem.size() > 2 ? (String)addressItem.get(2) : null;
        this.address = Address.fromString((NetworkParameters)netParams, (String)addressStr);
        this.balance = Coin.valueOf((long)Double.valueOf(balanceDouble * 1.0E8).longValue());
    }

    public Address getAddress() {
        return this.address;
    }

    public Coin getBalance() {
        return this.balance;
    }

    public String getAccount() {
        return this.account;
    }
}

