/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.conversion;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;

public class ECKeyDeserializer
extends JsonDeserializer<ECKey> {
    public ECKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        switch (token) {
            case VALUE_STRING: {
                try {
                    return DumpedPrivateKey.fromBase58(null, (String)p.getValueAsString()).getKey();
                }
                catch (AddressFormatException e) {
                    throw new InvalidFormatException(p, "Invalid Key", (Object)p.getValueAsString(), ECKey.class);
                }
            }
        }
        return (ECKey)ctxt.handleUnexpectedToken(ECKey.class, p);
    }
}

