/*
 * Decompiled with CFR 0.152.
 */
package com.commit451.foregroundviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import com.commit451.foregroundviews.ForegroundDelegate;

public class ForegroundButton
extends AppCompatButton {
    ForegroundDelegate mForegroundDelegate;

    public ForegroundButton(Context context) {
        this(context, null);
    }

    public ForegroundButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ForegroundButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate = new ForegroundDelegate((View)this);
            this.mForegroundDelegate.init(context, attrs, defStyle, 0);
        }
    }

    public int getForegroundGravity() {
        if (Build.VERSION.SDK_INT >= 23) {
            return super.getForegroundGravity();
        }
        return this.mForegroundDelegate.getForegroundGravity();
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (Build.VERSION.SDK_INT >= 23) {
            super.setForegroundGravity(foregroundGravity);
        } else {
            this.mForegroundDelegate.setForegroundGravity(foregroundGravity);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        if (Build.VERSION.SDK_INT < 23) {
            return super.verifyDrawable(who) || who == this.mForegroundDelegate.getForeground();
        }
        return super.verifyDrawable(who);
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.jumpDrawablesToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.drawableStateChanged();
        }
    }

    public void setForeground(Drawable foreground) {
        if (Build.VERSION.SDK_INT >= 23) {
            super.setForeground(foreground);
        } else {
            this.mForegroundDelegate.setForeground(foreground);
        }
    }

    public Drawable getForeground() {
        if (Build.VERSION.SDK_INT >= 23) {
            return super.getForeground();
        }
        return this.mForegroundDelegate.getForeground();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.onLayout(changed, left, top, right, bottom);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.draw(canvas);
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.drawableHotspotChanged(x, y);
        }
    }
}

