/*
 * Decompiled with CFR 0.152.
 */
package com.commit451.foregroundviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.commit451.foregroundviews.ForegroundDelegate;

public class ForegroundImageView
extends AppCompatImageView {
    ForegroundDelegate mForegroundDelegate = new ForegroundDelegate((View)this);

    public ForegroundImageView(Context context) {
        this(context, null);
    }

    public ForegroundImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ForegroundImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mForegroundDelegate.init(context, attrs, defStyle);
    }

    public int getForegroundGravity() {
        return this.mForegroundDelegate.getForegroundGravity();
    }

    public void setForegroundGravity(int foregroundGravity) {
        this.mForegroundDelegate.setForegroundGravity(foregroundGravity);
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mForegroundDelegate.getForeground();
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        this.mForegroundDelegate.jumpDrawablesToCurrentState();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.mForegroundDelegate.drawableStateChanged();
    }

    public void setForeground(Drawable drawable) {
        this.mForegroundDelegate.setForeground(drawable);
    }

    public Drawable getForeground() {
        return this.mForegroundDelegate.getForeground();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mForegroundDelegate.onLayout(changed, left, top, right, bottom);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundDelegate.onSizeChanged(w, h, oldw, oldh);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mForegroundDelegate.draw(canvas);
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        this.mForegroundDelegate.drawableHotspotChanged(x, y);
    }
}

