/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.util;

import me.coley.analysis.cfg.BlockHandler;
import me.coley.analysis.util.InsnUtil;
import me.coley.analysis.value.AbstractValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FlowUtil {
    public static boolean isFlowModifier(MethodNode method, int insnIndex, int successorIndex) {
        AbstractInsnNode dest = method.instructions.get(successorIndex);
        if (dest.getType() != 8) {
            return false;
        }
        AbstractInsnNode src = method.instructions.get(insnIndex);
        int srcType = src.getType();
        return srcType == 7 || srcType == 12 || srcType == 11;
    }

    public static boolean isNullChecked(BlockHandler blockHandler, AbstractValue value, AbstractInsnNode usage) {
        if (!value.isNull()) {
            return true;
        }
        JumpInsnNode nullCheck = value.getNullCheck();
        if (nullCheck == null) {
            return false;
        }
        Object safeInsn = null;
        safeInsn = nullCheck.getOpcode() == 198 ? nullCheck.getNext() : nullCheck.label;
        int safeIndex = InsnUtil.index(safeInsn);
        return blockHandler.getBlockAtIndex(safeIndex).getInsns().contains(usage);
    }
}

