/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.TargetInfo;
import software.coley.cafedude.classfile.annotation.TypeAnnotation;
import software.coley.cafedude.classfile.annotation.TypePath;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.DeprecatedAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SyntheticAttribute;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.DeclarationVisitor;
import software.coley.cafedude.tree.visitor.writer.AnnotationWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class DeclarationWriter
implements DeclarationVisitor {
    protected final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Annotation> visibleAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> invisibleAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> visibleTypeAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> invisibleTypeAnnotations = new ArrayList<Annotation>();
    protected Symbols symbols;

    DeclarationWriter(Symbols symbols) {
        this.symbols = symbols;
    }

    @Override
    @Nullable
    public DeclarationVisitor declarationDelegate() {
        return null;
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(@Nonnull String type, boolean visible) {
        return new AnnotationWriter(this.symbols, values -> {
            Annotation annotation = new Annotation(this.symbols.newUtf8(type), values);
            if (visible) {
                this.visibleAnnotations.add(annotation);
            } else {
                this.invisibleAnnotations.add(annotation);
            }
        });
    }

    @Override
    @Nullable
    public AnnotationVisitor visitTypeAnnotation(String type, TargetInfo target, TypePath path, boolean visible) {
        return new AnnotationWriter(this.symbols, values -> {
            TypeAnnotation typeAnnotation = new TypeAnnotation(this.symbols.newUtf8(type), values, target, path);
            if (visible) {
                this.visibleTypeAnnotations.add((Annotation)typeAnnotation);
            } else {
                this.invisibleTypeAnnotations.add((Annotation)typeAnnotation);
            }
        });
    }

    @Override
    public void visitSignature(@Nonnull String signature) {
        this.attributes.add((Attribute)new SignatureAttribute(this.symbols.newUtf8("Signature"), this.symbols.newUtf8(signature)));
    }

    @Override
    public void visitSynthetic(boolean synthetic) {
        if (synthetic) {
            this.attributes.add((Attribute)new SyntheticAttribute(this.symbols.newUtf8("Synthetic")));
        }
    }

    @Override
    public void visitDeprecated(boolean deprecated) {
        if (deprecated) {
            this.attributes.add((Attribute)new DeprecatedAttribute(this.symbols.newUtf8("Deprecated")));
        }
    }

    void visitDeclarationEnd() {
        if (!this.visibleAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new AnnotationsAttribute(this.symbols.newUtf8("RuntimeVisibleAnnotations"), this.visibleAnnotations, true));
        }
        if (!this.invisibleAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new AnnotationsAttribute(this.symbols.newUtf8("RuntimeInvisibleAnnotations"), this.invisibleAnnotations, false));
        }
        if (!this.visibleTypeAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new AnnotationsAttribute(this.symbols.newUtf8("RuntimeVisibleTypeAnnotations"), this.visibleTypeAnnotations, true));
        }
        if (!this.invisibleTypeAnnotations.isEmpty()) {
            this.attributes.add((Attribute)new AnnotationsAttribute(this.symbols.newUtf8("RuntimeInvisibleTypeAnnotations"), this.invisibleTypeAnnotations, false));
        }
    }
}

