/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.visitor.AnnotationArrayVisitor;
import software.coley.cafedude.tree.visitor.AnnotationDefaultVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.writer.AnnotationArrayWriter;
import software.coley.cafedude.tree.visitor.writer.AnnotationWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class AnnotationDefaultWriter
implements AnnotationDefaultVisitor {
    private final Symbols symbols;
    private final Consumer<ElementValue> callback;

    AnnotationDefaultWriter(Symbols symbols, Consumer<ElementValue> callback) {
        this.symbols = symbols;
        this.callback = callback;
    }

    @Override
    public void visitDefaultValue(@Nonnull Constant value) {
        this.callback.accept(this.symbols.newElementValue(value));
    }

    @Override
    @Nullable
    public AnnotationVisitor visitDefaultAnnotation(@Nonnull String type) {
        return new AnnotationWriter(this.symbols, ev -> {
            Annotation annotation = new Annotation(this.symbols.newUtf8(type), ev);
            this.callback.accept((ElementValue)new AnnotationElementValue('@', annotation));
        });
    }

    @Override
    @Nullable
    public AnnotationArrayVisitor visitDefaultArray() {
        return new AnnotationArrayWriter(this.symbols, elements -> this.callback.accept((ElementValue)new ArrayElementValue('[', elements)));
    }
}

