/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.reader;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.InvalidCodeException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFieldRef;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.CpRefInstruction;
import software.coley.cafedude.classfile.instruction.IincInstruction;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.classfile.instruction.LookupSwitchInstruction;
import software.coley.cafedude.classfile.instruction.MultiANewArrayInstruction;
import software.coley.cafedude.classfile.instruction.TableSwitchInstruction;
import software.coley.cafedude.classfile.instruction.WideInstruction;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.Handle;
import software.coley.cafedude.tree.Label;
import software.coley.cafedude.tree.frame.ObjectValue;
import software.coley.cafedude.tree.frame.PrimitiveValue;
import software.coley.cafedude.tree.frame.UninitializedValue;
import software.coley.cafedude.tree.frame.Value;
import software.coley.cafedude.tree.visitor.CodeVisitor;
import software.coley.cafedude.util.ConstantUtil;
import software.coley.cafedude.util.OpcodeUtil;
import software.coley.cafedude.util.Optional;

public class CodeReader {
    private static final Logger logger = LoggerFactory.getLogger(CodeReader.class);
    private final BootstrapMethodsAttribute bsma;
    private final LocalVariableTableAttribute lvta;
    private final LocalVariableTypeTableAttribute lvtta;
    private final StackMapTableAttribute smta;
    private final CodeVisitor cv;
    private final CodeAttribute ca;
    private final Method method;
    private final TreeMap<Integer, Label> labels;
    private final TreeMap<Integer, Instruction> instructions;
    private Stack<Value> stack = new Stack();
    private final Stack<Value> locals = new Stack();
    private static final Stack<Value> EMPTY = new Stack();

    public CodeReader(@Nonnull ClassFile clazz, @Nonnull CodeAttribute ca, @Nonnull CodeVisitor cv, @Nonnull Method method, @Nonnull TreeMap<Integer, Label> labels, @Nonnull TreeMap<Integer, Instruction> instructions) {
        this.bsma = (BootstrapMethodsAttribute)clazz.getAttribute(BootstrapMethodsAttribute.class);
        this.lvta = (LocalVariableTableAttribute)ca.getAttribute(LocalVariableTableAttribute.class);
        this.lvtta = (LocalVariableTypeTableAttribute)ca.getAttribute(LocalVariableTypeTableAttribute.class);
        this.smta = (StackMapTableAttribute)ca.getAttribute(StackMapTableAttribute.class);
        this.cv = cv;
        this.ca = ca;
        this.labels = labels;
        this.method = method;
        this.instructions = instructions;
    }

    public void accept() throws InvalidCodeException {
        if (this.instructions == null) {
            logger.warn("Method visited but no instructions present, Method=" + this.method.getName().getText());
            return;
        }
        if (this.instructions.isEmpty()) {
            return;
        }
        for (CodeAttribute.ExceptionTableEntry entry : this.ca.getExceptionTable()) {
            String type = (String)Optional.orNull((Object)entry.getCatchType(), t -> t.getName().getText());
            this.cv.visitExceptionHandler(type, this.labels.get(entry.getStartPc()), this.labels.get(entry.getEndPc()), this.labels.get(entry.getHandlerPc()));
        }
        Map<Integer, StackMapTableAttribute.StackMapFrame> frames = this.getStackMapFrames();
        int start = 0;
        int end = 0;
        if (!this.labels.isEmpty()) {
            end = this.labels.lastKey();
        }
        for (int pos = start; pos < end; ++pos) {
            Instruction insn;
            StackMapTableAttribute.StackMapFrame frame;
            Label currentLabel = this.labels.get(pos);
            if (currentLabel != null) {
                this.cv.visitLabel(currentLabel);
                for (Integer line : currentLabel.getLines()) {
                    this.cv.visitLineNumber(line, currentLabel);
                }
            }
            if ((frame = frames.get(pos)) != null) {
                this.visitFrame(frame);
            }
            if ((insn = this.instructions.get(pos)) instanceof IntOperandInstruction) {
                this.visitIntOpInsn((IntOperandInstruction)insn, pos);
                continue;
            }
            if (insn instanceof CpRefInstruction) {
                this.visitCpRefInsn((CpRefInstruction)insn, pos);
                continue;
            }
            if (insn instanceof IincInstruction) {
                this.visitIincInsn((IincInstruction)insn);
                continue;
            }
            if (insn instanceof MultiANewArrayInstruction) {
                this.visitMultiANewArrayInsn((MultiANewArrayInstruction)insn);
                continue;
            }
            if (insn instanceof WideInstruction) {
                Instruction backing = ((WideInstruction)insn).getBacking();
                if (backing instanceof IntOperandInstruction) {
                    this.visitIntOpInsn((IntOperandInstruction)backing, pos);
                    continue;
                }
                if (!(backing instanceof IincInstruction)) continue;
                this.visitIincInsn((IincInstruction)backing);
                continue;
            }
            if (insn instanceof LookupSwitchInstruction) {
                this.visitLookupSwitchInsn((LookupSwitchInstruction)insn, pos);
                continue;
            }
            if (insn instanceof TableSwitchInstruction) {
                this.visitTableSwitchInsn((TableSwitchInstruction)insn, pos);
                continue;
            }
            if (!(insn instanceof BasicInstruction)) continue;
            this.visitBasicInsn((BasicInstruction)insn, pos);
        }
        this.visitLocalVariables();
        this.cv.visitMaxs(this.ca.getMaxStack(), this.ca.getMaxLocals());
        this.cv.visitCodeEnd();
    }

    private void visitBasicInsn(@Nonnull BasicInstruction insn, int pos) {
        int opcode = insn.getOpcode();
        if (opcode >= 1 && opcode <= 15) {
            this.cv.visitConstantInsn(opcode);
        } else if (opcode >= 26 && opcode <= 45) {
            int base = opcode - 26;
            int var = base % 4;
            int type = base / 4;
            int op = 21 + type;
            this.cv.visitVarInsn(op, var);
        } else if (opcode >= 59 && opcode <= 78) {
            int base = opcode - 59;
            int var = base % 4;
            int type = base / 4;
            int op = 54 + type;
            this.cv.visitVarInsn(op, var);
        } else if (opcode >= 79 && opcode <= 86 || opcode >= 46 && opcode <= 53 || opcode == 190) {
            this.cv.visitArrayInsn(opcode);
        } else if (opcode >= 87 && opcode <= 95) {
            this.cv.visitStackInsn(opcode);
        } else if (opcode >= 96 && opcode <= 131 || opcode >= 133 && opcode <= 147 || opcode >= 148 && opcode <= 152) {
            this.cv.visitArithmeticInsn(opcode);
        } else if (opcode >= 172 && opcode <= 177) {
            this.cv.visitReturnInsn(opcode);
        } else {
            switch (opcode) {
                case 0: {
                    this.cv.visitNop();
                    break;
                }
                case 191: {
                    this.cv.visitThrow();
                    break;
                }
                case 194: 
                case 195: {
                    this.cv.visitMonitorInsn(opcode);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported opcode (no operand): " + OpcodeUtil.getOpcodeName((int)opcode) + " (" + opcode + ") at " + pos);
                }
            }
        }
    }

    private void visitLookupSwitchInsn(@Nonnull LookupSwitchInstruction insn, int pos) {
        List keys = insn.getKeys();
        List offsets = insn.getOffsets();
        int defaultOffset = insn.getDefault();
        Label defaultLabel = this.labels.get(pos + defaultOffset);
        Label[] labels = new Label[offsets.size()];
        for (int i = 0; i < offsets.size(); ++i) {
            labels[i] = this.labels.get(pos + (Integer)offsets.get(i));
        }
        int[] keysArr = new int[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            keysArr[i] = (Integer)keys.get(i);
        }
        this.cv.visitLookupSwitchInsn(defaultLabel, keysArr, labels);
    }

    private void visitTableSwitchInsn(@Nonnull TableSwitchInstruction insn, int pos) {
        int min = insn.getLow();
        int max = insn.getHigh();
        int defaultOffset = insn.getDefault();
        Label defaultLabel = this.labels.get(pos + defaultOffset);
        Label[] labels = new Label[max - min + 1];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.labels.get(pos + (Integer)insn.getOffsets().get(i));
        }
        this.cv.visitTableSwitchInsn(min, max, defaultLabel, labels);
    }

    private void visitIntOpInsn(@Nonnull IntOperandInstruction ioi, int pos) {
        int operand = ioi.getOperand();
        int opcode = ioi.getOpcode();
        if (opcode == 16 || opcode == 17 || opcode == 188 || opcode == 169) {
            this.cv.visitIntInsn(opcode, operand);
        } else if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58) {
            this.cv.visitVarInsn(opcode, operand);
        } else if (opcode >= 153 && opcode <= 168 || opcode >= 198 && opcode <= 201) {
            int targetPos = pos + operand;
            Label targetLabel = this.labels.get(targetPos);
            if (targetLabel == null) {
                throw new IllegalStateException("No label for target position: " + targetPos);
            }
            this.cv.visitFlowInsn(opcode, targetLabel);
        } else {
            throw new IllegalStateException("Unsupported opcode (integer operand): " + OpcodeUtil.getOpcodeName((int)opcode) + " " + operand + " (" + opcode + ") at " + pos);
        }
    }

    private void visitCpRefInsn(@Nonnull CpRefInstruction cpr, int pos) {
        int opcode = cpr.getOpcode();
        if (opcode == 187 || opcode == 189 || opcode == 192 || opcode == 193) {
            CpClass cc = (CpClass)cpr.getEntry();
            this.cv.visitTypeInsn(opcode, cc.getName().getText());
        } else if (opcode >= 178 && opcode <= 181) {
            CpFieldRef fr = (CpFieldRef)cpr.getEntry();
            CpNameType nt = fr.getNameType();
            String name = nt.getName().getText();
            String owner = fr.getClassRef().getName().getText();
            String type = nt.getType().getText();
            this.cv.visitFieldInsn(opcode, owner, name, Descriptor.from((String)type));
        } else if (opcode == 18 || opcode == 19 || opcode == 20) {
            this.cv.visitLdcInsn(ConstantUtil.from(cpr.getEntry()));
        } else if (opcode == 182 || opcode == 183 || opcode == 184 || opcode == 185) {
            ConstRef cr = (ConstRef)cpr.getEntry();
            CpNameType nt = cr.getNameType();
            String name = nt.getName().getText();
            String owner = cr.getClassRef().getName().getText();
            String type = nt.getType().getText();
            this.cv.visitMethodInsn(opcode, owner, name, Descriptor.from((String)type));
        } else if (opcode == 186) {
            if (this.bsma == null) {
                throw new IllegalStateException("INVOKEDYNAMIC instruction found, but no BootstrapMethodsAttribute present at " + pos);
            }
            CpInvokeDynamic id = (CpInvokeDynamic)cpr.getEntry();
            CpNameType nt = id.getNameType();
            String name = nt.getName().getText();
            String type = nt.getType().getText();
            BootstrapMethodsAttribute.BootstrapMethod bsm = (BootstrapMethodsAttribute.BootstrapMethod)this.bsma.getBootstrapMethods().get(id.getBsmIndex());
            CpMethodHandle mh = bsm.getBsmMethodRef();
            ConstRef mr = mh.getReference();
            CpNameType bsmnt = mr.getNameType();
            String bsmName = bsmnt.getName().getText();
            String bsmOwner = mr.getClassRef().getName().getText();
            String bsmType = bsmnt.getType().getText();
            Handle bsmHandle = new Handle(Handle.Tag.fromKind(mh.getKind()), bsmOwner, bsmName, Descriptor.from((String)bsmType));
            Constant[] args = new Constant[bsm.getArgs().size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ConstantUtil.from((CpEntry)bsm.getArgs().get(i));
            }
            this.cv.visitInvokeDynamicInsn(name, Descriptor.from((String)type), bsmHandle, args);
        }
    }

    private void visitIincInsn(@Nonnull IincInstruction iinc) {
        this.cv.visitIIncInsn(iinc.getVar(), iinc.getIncrement());
    }

    private void visitMultiANewArrayInsn(@Nonnull MultiANewArrayInstruction manai) {
        this.cv.visitMultiANewArrayInsn(manai.getDescriptor().getName().getText(), manai.getDimensions());
    }

    private void visitLocalVariables() {
        List varTypes = Collections.emptyList();
        if (this.lvtta != null) {
            varTypes = this.lvtta.getEntries();
        }
        if (this.lvta != null) {
            for (LocalVariableTableAttribute.VarEntry entry : this.lvta.getEntries()) {
                String name = entry.getName().getText();
                Descriptor desc = Descriptor.from((String)entry.getDesc().getText());
                String signature = null;
                for (LocalVariableTypeTableAttribute.VarTypeEntry varType : varTypes) {
                    if (varType.getIndex() != entry.getIndex() || varType.getStartPc() != entry.getStartPc()) continue;
                    signature = varType.getSignature().getText();
                    break;
                }
                Label start = this.labels.computeIfAbsent(entry.getStartPc(), Label::new);
                Label end = this.labels.computeIfAbsent(entry.getStartPc() + entry.getLength(), Label::new);
                this.cv.visitLocalVariable(entry.getIndex(), name, desc, signature, start, end);
            }
        }
    }

    private void visitFrame(@Nonnull StackMapTableAttribute.StackMapFrame frame) {
        int kind = 0;
        int argument = 0;
        if (frame instanceof StackMapTableAttribute.SameFrame || frame instanceof StackMapTableAttribute.SameFrameExtended) {
            kind = 3;
            this.stack = EMPTY;
        } else if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItem) {
            StackMapTableAttribute.SameLocalsOneStackItem slo = (StackMapTableAttribute.SameLocalsOneStackItem)frame;
            this.stack = new Stack();
            this.stack.push(this.toValue(slo.getStack()));
            kind = 4;
        } else if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItemExtended) {
            StackMapTableAttribute.SameLocalsOneStackItemExtended slo = (StackMapTableAttribute.SameLocalsOneStackItemExtended)frame;
            this.stack = new Stack();
            this.stack.push(this.toValue(slo.getStack()));
            kind = 4;
        } else if (frame instanceof StackMapTableAttribute.ChopFrame) {
            StackMapTableAttribute.ChopFrame cf = (StackMapTableAttribute.ChopFrame)frame;
            argument = cf.getAbsentVariables();
            for (int i = 0; i < argument; ++i) {
                this.locals.pop();
            }
            this.stack = EMPTY;
            kind = 2;
        } else if (frame instanceof StackMapTableAttribute.AppendFrame) {
            StackMapTableAttribute.AppendFrame af = (StackMapTableAttribute.AppendFrame)frame;
            argument = af.getAdditionalLocals().size();
            for (StackMapTableAttribute.TypeInfo local : af.getAdditionalLocals()) {
                this.locals.push(this.toValue(local));
            }
            this.stack = EMPTY;
            kind = 1;
        } else if (frame instanceof StackMapTableAttribute.FullFrame) {
            StackMapTableAttribute.FullFrame ff = (StackMapTableAttribute.FullFrame)frame;
            for (StackMapTableAttribute.TypeInfo local : ff.getLocals()) {
                this.locals.push(this.toValue(local));
            }
            for (StackMapTableAttribute.TypeInfo stackItem : ff.getStack()) {
                this.stack.push(this.toValue(stackItem));
            }
        } else {
            throw new IllegalStateException("Unsupported frame type: " + frame.getClass().getName());
        }
        this.cv.visitFrame(kind, this.stack.toArray(new Value[0]), this.locals.toArray(new Value[0]), argument);
    }

    @Nonnull
    private Value toValue(@Nonnull StackMapTableAttribute.TypeInfo typeInfo) {
        switch (typeInfo.getTag()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new PrimitiveValue(typeInfo.getTag());
            }
            case 7: {
                StackMapTableAttribute.ObjectVariableInfo objectInfo = (StackMapTableAttribute.ObjectVariableInfo)typeInfo;
                return new ObjectValue(objectInfo.getClassEntry().getName().getText());
            }
            case 8: {
                StackMapTableAttribute.UninitializedVariableInfo uninitializedInfo = (StackMapTableAttribute.UninitializedVariableInfo)typeInfo;
                return new UninitializedValue(this.labels.computeIfAbsent(uninitializedInfo.getOffset(), Label::new));
            }
        }
        throw new IllegalArgumentException("Unknown verification type tag " + typeInfo.getTag());
    }

    @Nonnull
    private Map<Integer, StackMapTableAttribute.StackMapFrame> getStackMapFrames() {
        if (this.smta == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, StackMapTableAttribute.StackMapFrame> frames = new HashMap<Integer, StackMapTableAttribute.StackMapFrame>();
        int offset = -1;
        for (StackMapTableAttribute.StackMapFrame frame : this.smta.getFrames()) {
            offset = offset == -1 ? frame.getOffsetDelta() : (offset += frame.getOffsetDelta() + 1);
            frames.put(offset, frame);
        }
        return frames;
    }
}

