/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree;

import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.tree.Handle;

public class Constant {
    private final Type type;
    private final Object value;

    private Constant(@Nonnull Type type, @Nonnull Object value) {
        this.type = type;
        this.value = value;
    }

    @Nonnull
    public static Constant of(boolean value) {
        return new Constant(Type.BOOLEAN, value);
    }

    @Nonnull
    public static Constant of(byte value) {
        return new Constant(Type.BYTE, value);
    }

    @Nonnull
    public static Constant of(char value) {
        return new Constant(Type.CHAR, Character.valueOf(value));
    }

    @Nonnull
    public static Constant of(short value) {
        return new Constant(Type.SHORT, value);
    }

    @Nonnull
    public static Constant of(float value) {
        return new Constant(Type.FLOAT, Float.valueOf(value));
    }

    @Nonnull
    public static Constant of(double value) {
        return new Constant(Type.DOUBLE, value);
    }

    @Nonnull
    public static Constant of(long value) {
        return new Constant(Type.LONG, value);
    }

    @Nonnull
    public static Constant of(int value) {
        return new Constant(Type.INT, value);
    }

    @Nonnull
    public static Constant of(@Nonnull String value) {
        return new Constant(Type.STRING, value);
    }

    @Nonnull
    public static Constant of(@Nonnull Descriptor value) {
        if (value.getKind() == Descriptor.Kind.OBJECT || value.getKind() == Descriptor.Kind.ARRAY || value.getKind() == Descriptor.Kind.METHOD) {
            return new Constant(Type.DESCRIPTOR, value);
        }
        throw new IllegalArgumentException("Invalid descriptor kind: " + value.getKind());
    }

    @Nonnull
    public static Constant of(@Nonnull Handle value) {
        return new Constant(Type.HANDLE, value);
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Nonnull
    public Object getValue() {
        return this.value;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        DESCRIPTOR,
        HANDLE;

    }
}

