/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import me.coley.cafedude.classfile.attribute.CodeAttribute;
import me.coley.cafedude.classfile.instruction.BasicInstruction;
import me.coley.cafedude.classfile.instruction.BiIntOperandInstruction;
import me.coley.cafedude.classfile.instruction.Instruction;
import me.coley.cafedude.classfile.instruction.IntOperandInstruction;
import me.coley.cafedude.classfile.instruction.LookupSwitchInstruction;
import me.coley.cafedude.classfile.instruction.TableSwitchInstruction;
import me.coley.cafedude.classfile.instruction.WideInstruction;
import me.coley.cafedude.io.FallbackInstructionReader;

public class InstructionReader {
    private final FallbackInstructionReader fallbackReader;

    public InstructionReader(FallbackInstructionReader fallbackReader) {
        this.fallbackReader = fallbackReader;
    }

    public InstructionReader() {
        this(FallbackInstructionReader.fail());
    }

    public List<Instruction> read(CodeAttribute attribute) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        ByteBuffer buffer = ByteBuffer.wrap(attribute.getCode());
        FallbackInstructionReader fallbackReader = this.fallbackReader;
        block44: while (buffer.hasRemaining()) {
            int opcode = buffer.get() & 0xFF;
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 16: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.get()));
                    continue block44;
                }
                case 17: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort()));
                    continue block44;
                }
                case 18: {
                    instructions.add(new IntOperandInstruction(18, buffer.get() & 0xFF));
                    continue block44;
                }
                case 19: 
                case 20: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.get() & 0xFF));
                    continue block44;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.get() & 0xFF));
                    continue block44;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 132: {
                    instructions.add(new BiIntOperandInstruction(132, buffer.get() & 0xFF, buffer.get()));
                    continue block44;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort()));
                    continue block44;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort()));
                    continue block44;
                }
                case 167: {
                    instructions.add(new IntOperandInstruction(167, buffer.getShort()));
                    continue block44;
                }
                case 168: {
                    instructions.add(new IntOperandInstruction(168, buffer.getShort()));
                    continue block44;
                }
                case 169: {
                    instructions.add(new IntOperandInstruction(169, buffer.get() & 0xFF));
                    continue block44;
                }
                case 170: {
                    int pos = buffer.position();
                    buffer.position(pos + (4 - pos & 3));
                    int dflt = buffer.getInt();
                    int low = buffer.getInt();
                    int high = buffer.getInt();
                    int count = high - low + 1;
                    ArrayList<Integer> offsets = new ArrayList<Integer>(count);
                    for (int i = 0; i < count; ++i) {
                        offsets.add(buffer.getInt());
                    }
                    instructions.add(new TableSwitchInstruction(dflt, low, high, offsets));
                    continue block44;
                }
                case 171: {
                    int pos = buffer.position();
                    buffer.position(pos + (4 - pos & 3));
                    int dflt = buffer.getInt();
                    int keyCount = buffer.getInt();
                    ArrayList<Integer> keys = new ArrayList<Integer>(keyCount);
                    ArrayList<Integer> offsets = new ArrayList<Integer>(keyCount);
                    for (int i = 0; i < keyCount; ++i) {
                        keys.add(buffer.getInt());
                        offsets.add(buffer.getInt());
                    }
                    instructions.add(new LookupSwitchInstruction(dflt, keys, offsets));
                    continue block44;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 186: {
                    int index = buffer.getShort() & 0xFFFF;
                    if ((buffer.get() | buffer.get()) != 0) {
                        throw new IllegalStateException("InvokeDynamic padding bytes are non-zero");
                    }
                    instructions.add(new IntOperandInstruction(186, index));
                    continue block44;
                }
                case 187: {
                    instructions.add(new IntOperandInstruction(187, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 188: {
                    instructions.add(new IntOperandInstruction(188, buffer.get() & 0xFF));
                    continue block44;
                }
                case 189: {
                    instructions.add(new IntOperandInstruction(189, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 190: {
                    instructions.add(new BasicInstruction(190));
                    continue block44;
                }
                case 191: {
                    instructions.add(new BasicInstruction(191));
                    continue block44;
                }
                case 192: 
                case 193: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort() & 0xFFFF));
                    continue block44;
                }
                case 194: 
                case 195: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block44;
                }
                case 196: {
                    int type = buffer.get() & 0xFF;
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            instructions.add(new WideInstruction(new IntOperandInstruction(type, buffer.getShort() & 0xFFFF)));
                            continue block44;
                        }
                        case 132: {
                            instructions.add(new WideInstruction(new BiIntOperandInstruction(132, buffer.getShort() & 0xFFFF, buffer.getShort())));
                            continue block44;
                        }
                    }
                    throw new IllegalStateException("Illegal wide instruction type: " + type);
                }
                case 197: {
                    instructions.add(new BiIntOperandInstruction(197, buffer.getShort() & 0xFFFF, buffer.get() & 0xFF));
                    continue block44;
                }
                case 198: 
                case 199: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getShort()));
                    continue block44;
                }
                case 200: 
                case 201: {
                    instructions.add(new IntOperandInstruction(opcode, buffer.getInt()));
                    continue block44;
                }
            }
            instructions.addAll(fallbackReader.read(opcode, buffer));
        }
        return instructions;
    }
}

