/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.coley.cafedude.classfile.ConstPool;
import me.coley.cafedude.classfile.annotation.Annotation;
import me.coley.cafedude.classfile.annotation.AnnotationElementValue;
import me.coley.cafedude.classfile.annotation.ArrayElementValue;
import me.coley.cafedude.classfile.annotation.ClassElementValue;
import me.coley.cafedude.classfile.annotation.ElementValue;
import me.coley.cafedude.classfile.annotation.EnumElementValue;
import me.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import me.coley.cafedude.classfile.annotation.TargetInfo;
import me.coley.cafedude.classfile.annotation.TargetInfoType;
import me.coley.cafedude.classfile.annotation.TypeAnnotation;
import me.coley.cafedude.classfile.annotation.TypePath;
import me.coley.cafedude.classfile.annotation.TypePathElement;
import me.coley.cafedude.classfile.annotation.TypePathKind;
import me.coley.cafedude.classfile.annotation.Utf8ElementValue;
import me.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import me.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AttributeContext;
import me.coley.cafedude.io.ClassFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationReader {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationReader.class);
    private final ClassFileReader reader;
    private final ConstPool cp;
    private final DataInputStream is;
    private final AttributeContext context;
    private final int nameIndex;
    private final int maxCpIndex;

    public AnnotationReader(ClassFileReader reader, ConstPool cp, DataInputStream is, int length, int nameIndex, AttributeContext context) throws IOException {
        this.reader = reader;
        this.cp = cp;
        byte[] data = new byte[length];
        is.readFully(data);
        this.is = new DataInputStream(new ByteArrayInputStream(data));
        this.nameIndex = nameIndex;
        this.context = context;
        this.maxCpIndex = cp.size();
    }

    public AnnotationDefaultAttribute readAnnotationDefault() {
        try {
            return new AnnotationDefaultAttribute(this.nameIndex, this.readElementValue());
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted AnnotationDefault", t);
            return null;
        }
    }

    public AnnotationsAttribute readAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("Annotations attribute has 0 items, skipping");
                return null;
            }
            HashSet<String> usedAnnotationTypes = new HashSet<String>();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < numAnnotations; ++i) {
                Annotation annotation = this.readAnnotation();
                if (this.reader.doDropDupeAnnotations()) {
                    String type = this.cp.getUtf(annotation.getTypeIndex());
                    if (usedAnnotationTypes.contains(type)) continue;
                    annotations.add(annotation);
                    usedAnnotationTypes.add(type);
                    continue;
                }
                annotations.add(annotation);
            }
            return new AnnotationsAttribute(this.nameIndex, annotations);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted Annotations", t);
            return null;
        }
    }

    public ParameterAnnotationsAttribute readParameterAnnotations() {
        try {
            int numParameters = this.is.readUnsignedByte();
            if (numParameters == 0) {
                logger.debug("ParameterAnnotations attribute has 0 items, skipping");
                return null;
            }
            LinkedHashMap<Integer, List<Annotation>> parameterAnnotations = new LinkedHashMap<Integer, List<Annotation>>();
            for (int p = 0; p < numParameters; ++p) {
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                int numAnnotations = this.is.readUnsignedShort();
                for (int i = 0; i < numAnnotations; ++i) {
                    annotations.add(this.readAnnotation());
                }
                parameterAnnotations.put(p, annotations);
            }
            return new ParameterAnnotationsAttribute(this.nameIndex, parameterAnnotations);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted ParameterAnnotations", t);
            return null;
        }
    }

    public AnnotationsAttribute readTypeAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("TypeAnnotations attribute has 0 items, skipping");
                return null;
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < numAnnotations; ++i) {
                annotations.add(this.readTypeAnnotation());
            }
            return new AnnotationsAttribute(this.nameIndex, annotations);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted TypeAnnotations", t);
            return null;
        }
    }

    private Annotation readAnnotation() throws IOException {
        int typeIndex = this.is.readUnsignedShort();
        if (typeIndex >= this.maxCpIndex) {
            logger.warn("Illegally formatted Annotation item, out of CP bounds, type_index={} >= {}", (Object)typeIndex, (Object)this.maxCpIndex);
            throw new IllegalArgumentException("Annotation type_index out of CP bounds!");
        }
        if (!this.cp.isIndexOfType(typeIndex, CpUtf8.class)) {
            logger.warn("Illegally formatted Annotation item, type_index={} != CP_UTF8", (Object)typeIndex);
            throw new IllegalArgumentException("Annotation type_index does not point to CP_UTF8!");
        }
        Map<Integer, ElementValue> values = this.readElementPairs();
        return new Annotation(typeIndex, values);
    }

    private TypeAnnotation readTypeAnnotation() throws IOException {
        TargetInfo info;
        int targetType = this.is.readUnsignedByte();
        AttributeContext expectedLocation = AttributeContext.fromAnnotationTargetType(targetType);
        if (!this.context.equals((Object)expectedLocation)) {
            throw new IllegalArgumentException("Annotation location does not match allowed locations for its type");
        }
        TargetInfoType targetInfoType = TargetInfoType.fromTargetType(targetType);
        switch (targetInfoType) {
            case TYPE_PARAMETER_TARGET: {
                int typeParameterIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeParameterTargetInfo(targetType, typeParameterIndex);
                break;
            }
            case SUPERTYPE_TARGET: {
                int superTypeIndex = this.is.readUnsignedShort();
                info = new TargetInfo.SuperTypeTargetInfo(targetType, superTypeIndex);
                break;
            }
            case TYPE_PARAMETER_BOUND_TARGET: {
                int typeParameterIndex = this.is.readUnsignedByte();
                int boundIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeParameterBoundTargetInfo(targetType, typeParameterIndex, boundIndex);
                break;
            }
            case EMPTY_TARGET: {
                info = new TargetInfo.EmptyTargetInfo(targetType);
                break;
            }
            case FORMAL_PARAMETER_TARGET: {
                int formalParameterIndex = this.is.readUnsignedByte();
                info = new TargetInfo.FormalParameterTargetInfo(targetType, formalParameterIndex);
                break;
            }
            case THROWS_TARGET: {
                int throwsTypeIndex = this.is.readUnsignedShort();
                info = new TargetInfo.ThrowsTargetInfo(targetType, throwsTypeIndex);
                break;
            }
            case LOCALVAR_TARGET: {
                ArrayList<TargetInfo.LocalVarTargetInfo.Variable> variables = new ArrayList<TargetInfo.LocalVarTargetInfo.Variable>();
                int tableLength = this.is.readUnsignedShort();
                for (int i = 0; i < tableLength; ++i) {
                    int startPc = this.is.readUnsignedShort();
                    int length = this.is.readUnsignedShort();
                    int index = this.is.readUnsignedShort();
                    variables.add(new TargetInfo.LocalVarTargetInfo.Variable(startPc, length, index));
                }
                info = new TargetInfo.LocalVarTargetInfo(targetType, variables);
                break;
            }
            case CATCH_TARGET: {
                int exceptionTableIndex = this.is.readUnsignedShort();
                info = new TargetInfo.CatchTargetInfo(targetType, exceptionTableIndex);
                break;
            }
            case OFFSET_TARGET: {
                int offset = this.is.readUnsignedShort();
                info = new TargetInfo.OffsetTargetInfo(targetType, offset);
                break;
            }
            case TYPE_ARGUMENT_TARGET: {
                int offset = this.is.readUnsignedShort();
                int typeArgumentIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeArgumentTargetInfo(targetType, offset, typeArgumentIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type argument target");
            }
        }
        TypePath typePath = this.readTypePath();
        int typeIndex = this.is.readUnsignedShort();
        Map<Integer, ElementValue> values = this.readElementPairs();
        return new TypeAnnotation(typeIndex, values, info, typePath);
    }

    private TypePath readTypePath() throws IOException {
        int length = this.is.readUnsignedByte();
        ArrayList<TypePathElement> elements = new ArrayList<TypePathElement>();
        for (int i = 0; i < length; ++i) {
            int kind = this.is.readUnsignedByte();
            int index = this.is.readUnsignedByte();
            elements.add(new TypePathElement(TypePathKind.fromValue(kind), index));
        }
        return new TypePath(elements);
    }

    private Map<Integer, ElementValue> readElementPairs() throws IOException {
        LinkedHashMap<Integer, ElementValue> values = new LinkedHashMap<Integer, ElementValue>();
        for (int numPairs = this.is.readUnsignedShort(); numPairs > 0; --numPairs) {
            int nameIndex = this.is.readUnsignedShort();
            ElementValue value = this.readElementValue();
            if (values.containsKey(nameIndex)) {
                throw new IllegalArgumentException("Element pairs already has field by name index: " + nameIndex);
            }
            values.put(nameIndex, value);
        }
        return values;
    }

    private ElementValue readElementValue() throws IOException {
        char tag = (char)this.is.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                int index = this.is.readUnsignedShort();
                return new PrimitiveElementValue(tag, index);
            }
            case 's': {
                int utfIndex = this.is.readUnsignedShort();
                return new Utf8ElementValue(tag, utfIndex);
            }
            case 'e': {
                int typeNameIndex = this.is.readUnsignedShort();
                int constNameIndex = this.is.readUnsignedShort();
                return new EnumElementValue(tag, typeNameIndex, constNameIndex);
            }
            case 'c': {
                int classInfoIndex = this.is.readUnsignedShort();
                return new ClassElementValue(tag, classInfoIndex);
            }
            case '@': {
                Annotation nestedAnnotation = this.readAnnotation();
                return new AnnotationElementValue(tag, nestedAnnotation);
            }
            case '[': {
                int numElements = this.is.readUnsignedShort();
                ArrayList<ElementValue> arrayValues = new ArrayList<ElementValue>();
                for (int i = 0; i < numElements; ++i) {
                    arrayValues.add(this.readElementValue());
                }
                return new ArrayElementValue(tag, arrayValues);
            }
        }
        logger.debug("Unknown element_value tag: ({}) '{}'", (Object)tag, (Object)Character.valueOf(tag));
        throw new IllegalArgumentException("Unrecognized tag for annotation element value: " + tag);
    }
}

