/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class RecordAttribute
extends Attribute {
    private List<RecordComponent> components;

    public RecordAttribute(int nameIndex, List<RecordComponent> components) {
        super(nameIndex);
        this.components = components;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        for (RecordComponent component : this.getComponents()) {
            set.addAll(component.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.components.stream().mapToInt(RecordComponent::length).sum();
    }

    public List<RecordComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<RecordComponent> components) {
        this.components = components;
    }

    public static class RecordComponent
    implements CpAccessor {
        private int nameIndex;
        private int descIndex;
        private List<Attribute> attributes;

        public RecordComponent(int nameIndex, int descIndex, List<Attribute> attributes) {
            this.nameIndex = nameIndex;
            this.descIndex = descIndex;
            this.attributes = attributes;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public void setNameIndex(int nameIndex) {
            this.nameIndex = nameIndex;
        }

        public int getDescIndex() {
            return this.descIndex;
        }

        public void setDescIndex(int descIndex) {
            this.descIndex = descIndex;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getNameIndex());
            set.add(this.getDescIndex());
            return set;
        }

        public int length() {
            int len = 6;
            for (Attribute attribute : this.attributes) {
                len += attribute.computeCompleteLength();
            }
            return len;
        }
    }
}

