/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.Collection;
import java.util.EnumSet;
import me.coley.cafedude.classfile.AttributeConstants;
import me.coley.cafedude.io.AttributeContext;

public class AttributeContexts
implements AttributeConstants {
    public static Collection<AttributeContext> getAllowedContexts(String attributeName) {
        switch (attributeName) {
            case "BootstrapMethods": 
            case "EnclosingMethod": 
            case "InnerClasses": 
            case "Module": 
            case "ModuleMainClass": 
            case "ModulePackages": 
            case "NestHost": 
            case "NestMembers": 
            case "PermittedSubclasses": 
            case "Record": 
            case "SourceDebugExtension": 
            case "SourceFile": {
                return EnumSet.of(AttributeContext.CLASS);
            }
            case "ConstantValue": {
                return EnumSet.of(AttributeContext.FIELD);
            }
            case "AnnotationDefault": 
            case "Code": 
            case "Exceptions": 
            case "MethodParameters": 
            case "RuntimeInvisibleParameterAnnotations": 
            case "RuntimeVisibleParameterAnnotations": {
                return EnumSet.of(AttributeContext.METHOD);
            }
            case "Deprecated": 
            case "Synthetic": {
                return EnumSet.of(AttributeContext.CLASS, AttributeContext.FIELD, AttributeContext.METHOD);
            }
            case "LineNumberTable": 
            case "LocalVariableTable": 
            case "LocalVariableTypeTable": 
            case "StackMapTable": {
                return EnumSet.of(AttributeContext.ATTRIBUTE);
            }
            case "RuntimeVisibleAnnotations": 
            case "RuntimeVisibleTypeAnnotations": 
            case "RuntimeInvisibleAnnotations": 
            case "RuntimeInvisibleTypeAnnotations": 
            case "Signature": {
                return EnumSet.allOf(AttributeContext.class);
            }
        }
        return EnumSet.allOf(AttributeContext.class);
    }
}

