/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.ClassMember;
import me.coley.cafedude.classfile.ConstPool;
import me.coley.cafedude.classfile.Field;
import me.coley.cafedude.classfile.Method;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.AttributeHolder;
import me.coley.cafedude.classfile.behavior.CpAccessor;
import me.coley.cafedude.classfile.constant.ConstPoolEntry;
import me.coley.cafedude.classfile.constant.CpClass;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AttributeContext;

public class ClassFile
implements AttributeHolder,
CpAccessor {
    private final ConstPool pool;
    private List<Integer> interfaceIndices;
    private List<Field> fields;
    private List<Method> methods;
    private List<Attribute> attributes;
    private int access;
    private int versionMinor;
    private int versionMajor;
    private int classIndex;
    private int superIndex;

    public ClassFile(int versionMinor, int versionMajor, ConstPool pool, int access, int classIndex, int superIndex, List<Integer> interfaceIndices, List<Field> fields, List<Method> methods, List<Attribute> attributes) {
        this.versionMinor = versionMinor;
        this.versionMajor = versionMajor;
        this.pool = pool;
        this.access = access;
        this.classIndex = classIndex;
        this.superIndex = superIndex;
        this.interfaceIndices = interfaceIndices;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
    }

    public String getName() {
        return this.getClassName(this.classIndex);
    }

    public String getSuperName() {
        return this.getClassName(this.superIndex);
    }

    private String getClassName(int classIndex) {
        CpClass cpClass = (CpClass)this.getCp(classIndex);
        CpUtf8 cpClassName = (CpUtf8)this.getCp(cpClass.getIndex());
        return cpClassName.getText();
    }

    public ConstPoolEntry getCp(int index) {
        return this.pool.get(index);
    }

    public void setCp(int index, ConstPoolEntry entry) {
        this.pool.set(index, entry);
    }

    public ConstPool getPool() {
        return this.pool;
    }

    public List<Integer> getInterfaceIndices() {
        return this.interfaceIndices;
    }

    public void setInterfaceIndices(List<Integer> interfaceIndices) {
        this.interfaceIndices = interfaceIndices;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public int getSuperIndex() {
        return this.superIndex;
    }

    public void setSuperIndex(int superIndex) {
        this.superIndex = superIndex;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public AttributeContext getHolderType() {
        return AttributeContext.CLASS;
    }

    @Override
    public Set<Integer> cpAccesses() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(this.getClassIndex());
        set.add(this.getSuperIndex());
        set.addAll(this.getInterfaceIndices());
        for (Attribute attribute : this.getAttributes()) {
            set.addAll(attribute.cpAccesses());
        }
        for (ClassMember classMember : this.getFields()) {
            set.addAll(classMember.cpAccesses());
        }
        for (ClassMember classMember : this.getMethods()) {
            set.addAll(classMember.cpAccesses());
        }
        return set;
    }
}

