/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.blackreflection.proxy;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import top.niunaijun.blackreflection.BlackReflectionInterfaceInfo;
import top.niunaijun.blackreflection.annotation.BClassNameNotProcess;
import top.niunaijun.blackreflection.annotation.BConstructor;
import top.niunaijun.blackreflection.annotation.BConstructorNotProcess;
import top.niunaijun.blackreflection.annotation.BFieldCheckNotProcess;
import top.niunaijun.blackreflection.annotation.BFieldNotProcess;
import top.niunaijun.blackreflection.annotation.BFieldSetNotProcess;
import top.niunaijun.blackreflection.annotation.BMethodCheckNotProcess;
import top.niunaijun.blackreflection.annotation.BParamClass;
import top.niunaijun.blackreflection.annotation.BParamClassName;

public class BlackReflectionInterfaceProxy {
    private final List<BlackReflectionInterfaceInfo> mReflections = new ArrayList<BlackReflectionInterfaceInfo>();
    private final String mClassName;
    private final String mPackageName;
    private final String mOrigClassName;
    private Map<String, String> realMaps;

    public BlackReflectionInterfaceProxy(String packageName, String className, String origClassName) {
        this.mPackageName = packageName;
        this.mClassName = className;
        this.mOrigClassName = origClassName;
    }

    public JavaFile generateInterfaceCode() {
        String finalClass = this.mClassName.replace(this.mPackageName + ".", "").replace(".", "");
        AnnotationSpec annotationSpec = AnnotationSpec.builder(BClassNameNotProcess.class).addMember("value", "$S", new Object[]{this.realMaps.get(this.mOrigClassName)}).build();
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)finalClass).addAnnotation(annotationSpec).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (BlackReflectionInterfaceInfo reflection : this.mReflections) {
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)reflection.getExecutableElement().getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (VariableElement variableElement : reflection.getExecutableElement().getParameters()) {
                BParamClassName annotation;
                ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)ClassName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]);
                if (variableElement.getAnnotation(BParamClassName.class) != null) {
                    annotation = variableElement.getAnnotation(BParamClassName.class);
                    builder.addAnnotation(AnnotationSpec.get((Annotation)annotation));
                }
                if (variableElement.getAnnotation(BParamClass.class) != null) {
                    annotation = variableElement.getAnnotation(BParamClass.class);
                    String annotationValue = BlackReflectionInterfaceProxy.getClass((BParamClass)annotation).toString();
                    Class<?> aClass = BlackReflectionInterfaceProxy.parseBaseClass(annotationValue);
                    if (aClass != null) {
                        builder.addAnnotation(AnnotationSpec.builder(BParamClass.class).addMember("value", "$T.class", new Object[]{aClass}).build());
                    } else {
                        builder.addAnnotation(AnnotationSpec.builder(BParamClass.class).addMember("value", annotationValue + ".class", new Object[0]).build());
                    }
                }
                ParameterSpec build = builder.build();
                parameterSpecs.add(build);
                method.addParameter(build);
            }
            TypeName typeName = TypeName.get((TypeMirror)reflection.getExecutableElement().getReturnType());
            method.returns(typeName.box());
            if (reflection.isField()) {
                method.addAnnotation(AnnotationSpec.builder(BFieldNotProcess.class).build());
                interfaceBuilder.addMethod(this.generateFieldSet(reflection));
                interfaceBuilder.addMethod(this.generateFieldCheck(reflection));
            } else {
                BConstructor bConstructor = reflection.getExecutableElement().getAnnotation(BConstructor.class);
                if (bConstructor != null) {
                    method.addAnnotation(AnnotationSpec.builder(BConstructorNotProcess.class).build());
                } else {
                    interfaceBuilder.addMethod(this.generateMethodCheck(reflection, parameterSpecs));
                }
            }
            interfaceBuilder.addMethod(method.build());
        }
        return JavaFile.builder((String)this.mPackageName, (TypeSpec)interfaceBuilder.build()).build();
    }

    private MethodSpec generateFieldSet(BlackReflectionInterfaceInfo reflection) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("_set_" + reflection.getExecutableElement().getSimpleName().toString())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), "value", new Modifier[]{Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(BFieldSetNotProcess.class).build());
        return method.build();
    }

    private MethodSpec generateFieldCheck(BlackReflectionInterfaceInfo reflection) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("_check_" + reflection.getExecutableElement().getSimpleName().toString())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BFieldCheckNotProcess.class).build()).returns(Field.class);
        return method.build();
    }

    private MethodSpec generateMethodCheck(BlackReflectionInterfaceInfo reflection, List<ParameterSpec> parameterSpecs) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("_check_" + reflection.getExecutableElement().getSimpleName().toString())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BMethodCheckNotProcess.class).build()).returns(Method.class);
        for (ParameterSpec parameterSpec : parameterSpecs) {
            method.addParameter(parameterSpec);
        }
        return method.build();
    }

    public void add(BlackReflectionInterfaceInfo interfaceInfo) {
        this.mReflections.add(interfaceInfo);
    }

    public void setRealMap(Map<String, String> realMaps) {
        this.realMaps = realMaps;
    }

    private static TypeMirror getClass(BParamClass annotation) {
        try {
            annotation.value();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }

    private static Class<?> parseBaseClass(String className) {
        switch (className) {
            case "int": {
                return Integer.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int[]": {
                return int[].class;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "long[]": {
                return long[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "double[]": {
                return double[].class;
            }
            case "boolean[]": {
                return boolean[].class;
            }
            case "char[]": {
                return char[].class;
            }
        }
        return null;
    }
}

