/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v340.serializer;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.structure.StructureAnimationMode;
import com.nukkitx.protocol.bedrock.data.structure.StructureBlockType;
import com.nukkitx.protocol.bedrock.data.structure.StructureEditorData;
import com.nukkitx.protocol.bedrock.data.structure.StructureMirror;
import com.nukkitx.protocol.bedrock.data.structure.StructureRedstoneSaveMode;
import com.nukkitx.protocol.bedrock.data.structure.StructureRotation;
import com.nukkitx.protocol.bedrock.data.structure.StructureSettings;
import com.nukkitx.protocol.bedrock.packet.StructureBlockUpdatePacket;
import io.netty.buffer.ByteBuf;

public class StructureBlockUpdateSerializer_v340
implements BedrockPacketSerializer<StructureBlockUpdatePacket> {
    public static final StructureBlockUpdateSerializer_v340 INSTANCE = new StructureBlockUpdateSerializer_v340();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, StructureBlockUpdatePacket packet) {
        StructureEditorData editorData = packet.getEditorData();
        StructureSettings settings = editorData.getSettings();
        helper.writeBlockPosition(buffer, packet.getBlockPosition());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)editorData.getType().ordinal());
        helper.writeString(buffer, editorData.getName());
        helper.writeString(buffer, editorData.getName());
        helper.writeBlockPosition(buffer, settings.getOffset());
        helper.writeBlockPosition(buffer, settings.getSize());
        buffer.writeBoolean(!settings.isIgnoringEntities());
        buffer.writeBoolean(settings.isIgnoringBlocks());
        buffer.writeBoolean(editorData.isIncludingPlayers());
        buffer.writeBoolean(false);
        buffer.writeFloatLE(settings.getIntegrityValue());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)settings.getIntegritySeed());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)settings.getMirror().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)settings.getRotation().ordinal());
        buffer.writeBoolean(settings.isIgnoringEntities());
        buffer.writeBoolean(true);
        Vector3i min = packet.getBlockPosition().add(settings.getOffset());
        helper.writeVector3i(buffer, min);
        Vector3i max = min.add(settings.getSize());
        helper.writeVector3i(buffer, max);
        buffer.writeBoolean(editorData.isBoundingBoxVisible());
        buffer.writeBoolean(packet.isPowered());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, StructureBlockUpdatePacket packet) {
        packet.setBlockPosition(helper.readBlockPosition(buffer));
        StructureBlockType structureType = StructureBlockType.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
        String name = helper.readString(buffer);
        String dataField = helper.readString(buffer);
        Vector3i offset = helper.readBlockPosition(buffer);
        Vector3i size = helper.readBlockPosition(buffer);
        buffer.readBoolean();
        boolean ignoreBlocks = !buffer.readBoolean();
        boolean includePlayers = buffer.readBoolean();
        buffer.readBoolean();
        float structureIntegrity = buffer.readFloatLE();
        int integritySeed = VarInts.readUnsignedInt((ByteBuf)buffer);
        StructureMirror mirror = StructureMirror.from((int)VarInts.readUnsignedInt((ByteBuf)buffer));
        StructureRotation rotation = StructureRotation.from((int)VarInts.readUnsignedInt((ByteBuf)buffer));
        boolean ignoreEntities = buffer.readBoolean();
        buffer.readBoolean();
        helper.readVector3i(buffer);
        helper.readVector3i(buffer);
        boolean boundingBoxVisible = buffer.readBoolean();
        StructureSettings settings = new StructureSettings("", ignoreEntities, ignoreBlocks, size, offset, -1L, rotation, mirror, StructureAnimationMode.NONE, 0.0f, structureIntegrity, integritySeed, Vector3f.ZERO);
        StructureEditorData editorData = new StructureEditorData(name, dataField, includePlayers, boundingBoxVisible, structureType, settings, StructureRedstoneSaveMode.SAVES_TO_DISK);
        packet.setEditorData(editorData);
        packet.setPowered(buffer.readBoolean());
    }

    protected StructureBlockUpdateSerializer_v340() {
    }
}

