/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;

public class VideoStreamConnectPacket
extends BedrockPacket {
    private String address;
    private float screenshotFrequency;
    private Action action;
    private int width;
    private int height;

    @Override
    public boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.VIDEO_STREAM_CONNECT;
    }

    public String getAddress() {
        return this.address;
    }

    public float getScreenshotFrequency() {
        return this.screenshotFrequency;
    }

    public Action getAction() {
        return this.action;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setScreenshotFrequency(float screenshotFrequency) {
        this.screenshotFrequency = screenshotFrequency;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return "VideoStreamConnectPacket(address=" + this.getAddress() + ", screenshotFrequency=" + this.getScreenshotFrequency() + ", action=" + (Object)((Object)this.getAction()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoStreamConnectPacket)) {
            return false;
        }
        VideoStreamConnectPacket other = (VideoStreamConnectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.address;
        String other$address = other.address;
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (Float.compare(this.screenshotFrequency, other.screenshotFrequency) != 0) {
            return false;
        }
        Action this$action = this.action;
        Action other$action = other.action;
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        return this.height == other.height;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VideoStreamConnectPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.address;
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + Float.floatToIntBits(this.screenshotFrequency);
        Action $action = this.action;
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + this.width;
        result = result * 59 + this.height;
        return result;
    }

    public static enum Action {
        OPEN,
        CLOSE;

    }
}

