/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCounted;

public final class UnknownPacket
extends BedrockPacket
implements BedrockPacketSerializer<UnknownPacket>,
ReferenceCounted {
    private ByteBuf payload;

    @Override
    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, UnknownPacket packet) {
        buffer.writeBytes(packet.payload);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, UnknownPacket packet) {
        packet.payload = buffer.readRetainedSlice(buffer.readableBytes());
    }

    @Override
    public String toString() {
        return "UNKNOWN - " + this.getPacketId() + " - Hex: " + (this.payload == null || this.payload.refCnt() == 0 ? "null" : ByteBufUtil.hexDump((ByteBuf)this.payload));
    }

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return false;
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.UNKNOWN;
    }

    public int refCnt() {
        if (this.payload == null) {
            return 0;
        }
        return this.payload.refCnt();
    }

    public UnknownPacket retain() {
        if (this.payload != null) {
            this.payload.retain();
        }
        return this;
    }

    public UnknownPacket retain(int increment) {
        if (this.payload != null) {
            this.payload.retain(increment);
        }
        return this;
    }

    public UnknownPacket touch() {
        if (this.payload != null) {
            this.payload.touch();
        }
        return this;
    }

    public UnknownPacket touch(Object hint) {
        if (this.payload != null) {
            this.payload.touch(hint);
        }
        return this;
    }

    public boolean release() {
        return this.payload == null || this.payload.release();
    }

    public boolean release(int decrement) {
        return this.payload == null || this.payload.release(decrement);
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnknownPacket)) {
            return false;
        }
        UnknownPacket other = (UnknownPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteBuf this$payload = this.payload;
        ByteBuf other$payload = other.payload;
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnknownPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteBuf $payload = this.payload;
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }
}

