/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class ExplodePacket
extends BedrockPacket {
    private final List<Vector3i> records = new ObjectArrayList();
    private Vector3f position;
    private float radius;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.EXPLODE;
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    @Override
    public String toString() {
        return "ExplodePacket(records=" + this.getRecords() + ", position=" + this.getPosition() + ", radius=" + this.getRadius() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplodePacket)) {
            return false;
        }
        ExplodePacket other = (ExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Vector3i> this$records = this.records;
        List<Vector3i> other$records = other.records;
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        return Float.compare(this.radius, other.radius) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExplodePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Vector3i> $records = this.records;
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        result = result * 59 + Float.floatToIntBits(this.radius);
        return result;
    }
}

