/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.raknet.EncapsulatedPacket;
import com.nukkitx.network.raknet.RakNetSession;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.protocol.bedrock.BedrockClient;
import com.nukkitx.protocol.bedrock.BedrockClientSession;
import com.nukkitx.protocol.bedrock.BedrockServer;
import com.nukkitx.protocol.bedrock.BedrockServerEventHandler;
import com.nukkitx.protocol.bedrock.BedrockServerSession;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.exception.ConnectionFailedException;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class BedrockRakNetSessionListener
implements RakNetSessionListener {
    final BedrockSession session;
    private final RakNetSession connection;

    public void onEncapsulated(EncapsulatedPacket packet) {
        if (this.connection.getState() != RakNetState.CONNECTED) {
            return;
        }
        ByteBuf buffer = packet.getBuffer();
        short packetId = buffer.readUnsignedByte();
        if (packetId == 254 && buffer.isReadable()) {
            if (this.session.getEventLoop().inEventLoop()) {
                this.session.onWrappedPacket(buffer);
            } else {
                buffer.retain();
                this.session.getEventLoop().execute(() -> {
                    try {
                        this.session.onWrappedPacket(buffer);
                    }
                    finally {
                        buffer.release();
                    }
                });
            }
        }
    }

    public void onDirect(ByteBuf buf) {
    }

    BedrockRakNetSessionListener(BedrockSession session, RakNetSession connection) {
        this.session = session;
        this.connection = connection;
    }

    @ParametersAreNonnullByDefault
    public static class Server
    extends BedrockRakNetSessionListener {
        private final BedrockServer server;

        Server(BedrockServerSession session, RakNetSession connection, BedrockServer server) {
            super(session, connection);
            this.server = server;
        }

        public void onSessionChangeState(RakNetState state) {
            if (state == RakNetState.CONNECTED) {
                this.server.sessions.add((BedrockServerSession)this.session);
                BedrockServerEventHandler handler = this.server.getHandler();
                if (handler != null) {
                    handler.onSessionCreation((BedrockServerSession)this.session);
                }
            }
        }

        public void onDisconnect(DisconnectReason reason) {
            this.session.close(reason);
            this.server.sessions.remove((BedrockServerSession)this.session);
        }
    }

    @ParametersAreNonnullByDefault
    public static class Client
    extends BedrockRakNetSessionListener {
        CompletableFuture<BedrockClientSession> future;
        private final BedrockClient client;

        Client(BedrockClientSession session, RakNetSession connection, BedrockClient client, CompletableFuture<BedrockClientSession> future) {
            super(session, connection);
            this.client = client;
            this.future = future;
        }

        public void onSessionChangeState(RakNetState state) {
            if (state == RakNetState.CONNECTED && this.future != null) {
                this.future.complete((BedrockClientSession)this.session);
                this.future = null;
            }
        }

        public void onDisconnect(DisconnectReason reason) {
            this.session.close(reason);
            if (this.future != null && !this.future.isDone()) {
                this.future.completeExceptionally(new ConnectionFailedException(reason));
            }
            this.client.session = null;
        }
    }
}

