/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerListItemTransactionBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.support.TransactionDiffCallback;
import com.chuckerteam.chucker.internal.ui.transaction.ProtocolResources;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapterKt;
import java.text.DateFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0001+B9\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u001b\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u001c\u0010\u001f\u001a\u00020\t2\n\u0010 \u001a\u00060\u0003R\u00020\u00002\u0006\u0010!\u001a\u00020\u0012H\u0016J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b&J\u001b\u0010'\u001a\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)H\u0001\u00a2\u0006\u0002\b*R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "context", "Landroid/content/Context;", "onTransactionClick", "Lkotlin/Function1;", "", "", "onTransactionLongClick", "<init>", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "isSelectionMode", "", "selectedTransactionIds", "", "colorDefault", "", "colorRequested", "colorError", "color500", "color400", "color300", "colorSelected", "backgroundSelectableAttr", "Landroid/util/TypedValue;", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onBindViewHolder", "holder", "position", "setSelectionMode", "enabled", "setSelectionMode$com_github_ChuckerTeam_Chucker_library", "clearSelections", "clearSelections$com_github_ChuckerTeam_Chucker_library", "setSelectedTransactionIds", "ids", "", "setSelectedTransactionIds$com_github_ChuckerTeam_Chucker_library", "TransactionViewHolder", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionAdapter.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1924#2,2:253\n363#2,7:255\n1926#2:262\n*S KotlinDebug\n*F\n+ 1 TransactionAdapter.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter\n*L\n100#1:253,2\n101#1:255,7\n100#1:262\n*E\n"})
public final class TransactionAdapter
extends ListAdapter<HttpTransactionTuple, TransactionViewHolder> {
    @NotNull
    private final Function1<Long, Unit> onTransactionClick;
    @NotNull
    private final Function1<Long, Unit> onTransactionLongClick;
    private boolean isSelectionMode;
    @NotNull
    private final Set<Long> selectedTransactionIds;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;
    private final int colorSelected;
    @NotNull
    private final TypedValue backgroundSelectableAttr;

    /*
     * WARNING - void declaration
     */
    public TransactionAdapter(@NotNull Context context, @NotNull Function1<? super Long, Unit> onTransactionClick, @NotNull Function1<? super Long, Unit> onTransactionLongClick) {
        void it;
        TypedValue typedValue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onTransactionClick, (String)"onTransactionClick");
        Intrinsics.checkNotNullParameter(onTransactionLongClick, (String)"onTransactionLongClick");
        super((DiffUtil.ItemCallback)TransactionDiffCallback.INSTANCE);
        this.onTransactionClick = onTransactionClick;
        this.onTransactionLongClick = onTransactionLongClick;
        this.selectedTransactionIds = new LinkedHashSet();
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_300);
        this.colorSelected = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_multiple_selection);
        TypedValue typedValue2 = typedValue = new TypedValue();
        TransactionAdapter transactionAdapter = this;
        boolean bl = false;
        context.getTheme().resolveAttribute(16843534, (TypedValue)it, true);
        transactionAdapter.backgroundSelectableAttr = typedValue;
    }

    @NotNull
    public TransactionViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ChuckerListItemTransactionBinding chuckerListItemTransactionBinding = ChuckerListItemTransactionBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerListItemTransactionBinding, (String)"inflate(...)");
        ChuckerListItemTransactionBinding viewBinding = chuckerListItemTransactionBinding;
        return new TransactionViewHolder(viewBinding);
    }

    public void onBindViewHolder(@NotNull TransactionViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Object object = this.getItem(position);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        holder.bind((HttpTransactionTuple)object);
    }

    public final void setSelectionMode$com_github_ChuckerTeam_Chucker_library(boolean enabled) {
        this.isSelectionMode = enabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void clearSelections$com_github_ChuckerTeam_Chucker_library() {
        Set previouslySelectedIds = CollectionsKt.toSet((Iterable)this.selectedTransactionIds);
        this.selectedTransactionIds.clear();
        Iterable $this$forEachIndexed$iv = previouslySelectedIds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int position;
            int n;
            block4: {
                List $this$indexOfFirst$iv;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l = ((Number)item$iv).longValue();
                int index = n2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.getCurrentList(), (String)"getCurrentList(...)");
                boolean $i$f$indexOfFirst = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$indexOfFirst$iv) {
                    void id2;
                    HttpTransactionTuple it = (HttpTransactionTuple)item$iv2;
                    boolean bl2 = false;
                    if (it.getId() == id2) {
                        n = index$iv2;
                        break block4;
                    }
                    ++index$iv2;
                }
                n = -1;
            }
            if ((position = n) == -1) continue;
            this.notifyItemChanged(position);
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void setSelectedTransactionIds$com_github_ChuckerTeam_Chucker_library(@NotNull List<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.selectedTransactionIds.clear();
        this.selectedTransactionIds.addAll((Collection<Long>)ids);
        this.notifyDataSetChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;", "<init>", "(Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;)V", "transactionId", "", "Ljava/lang/Long;", "bind", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "toggleSelection", "id", "updateSelectionState", "setProtocolImage", "resources", "Lcom/chuckerteam/chucker/internal/ui/transaction/ProtocolResources;", "setStatusColor", "com.github.ChuckerTeam.Chucker.library"})
    public final class TransactionViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ChuckerListItemTransactionBinding itemBinding;
        @Nullable
        private Long transactionId;

        public TransactionViewHolder(ChuckerListItemTransactionBinding itemBinding) {
            Intrinsics.checkNotNullParameter((Object)itemBinding, (String)"itemBinding");
            super((View)itemBinding.getRoot());
            this.itemBinding = itemBinding;
            this.itemView.setOnClickListener(arg_0 -> TransactionViewHolder._init_$lambda$0(this, TransactionAdapter.this, arg_0));
            this.itemView.setOnLongClickListener(arg_0 -> TransactionViewHolder._init_$lambda$1(this, TransactionAdapter.this, arg_0));
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@NotNull HttpTransactionTuple transaction) {
            ChuckerListItemTransactionBinding chuckerListItemTransactionBinding;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            this.transactionId = transaction.getId();
            this.updateSelectionState(transaction.getId());
            ChuckerListItemTransactionBinding $this$bind_u24lambda_u240 = chuckerListItemTransactionBinding = this.itemBinding;
            boolean bl = false;
            TransactionAdapterKt.access$displayGraphQlFields($this$bind_u24lambda_u240, transaction.getGraphQlOperationName(), transaction.getGraphQlDetected());
            $this$bind_u24lambda_u240.path.setText((CharSequence)(transaction.getMethod() + " " + transaction.getFormattedPath(false)));
            $this$bind_u24lambda_u240.host.setText((CharSequence)transaction.getHost());
            $this$bind_u24lambda_u240.timeStart.setText((CharSequence)DateFormat.getTimeInstance().format(transaction.getRequestDate()));
            this.setProtocolImage(transaction.isSsl() ? (ProtocolResources)new ProtocolResources.Https() : (ProtocolResources)new ProtocolResources.Http());
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                $this$bind_u24lambda_u240.code.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                $this$bind_u24lambda_u240.duration.setText((CharSequence)transaction.getDurationString());
                $this$bind_u24lambda_u240.size.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                $this$bind_u24lambda_u240.code.setText((CharSequence)"");
                $this$bind_u24lambda_u240.duration.setText((CharSequence)"");
                $this$bind_u24lambda_u240.size.setText((CharSequence)"");
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                $this$bind_u24lambda_u240.code.setText((CharSequence)"!!!");
            }
            this.setStatusColor(transaction);
        }

        private final void toggleSelection(long id2) {
            boolean bl = TransactionAdapter.this.selectedTransactionIds.contains(id2) ? TransactionAdapter.this.selectedTransactionIds.remove(id2) : TransactionAdapter.this.selectedTransactionIds.add(id2);
            TransactionAdapter.this.notifyItemChanged(this.getAdapterPosition());
        }

        private final void updateSelectionState(long transactionId) {
            if (TransactionAdapter.this.selectedTransactionIds.contains(transactionId)) {
                this.itemView.setBackgroundColor(TransactionAdapter.this.colorSelected);
            } else {
                this.itemView.setBackgroundResource(((TransactionAdapter)TransactionAdapter.this).backgroundSelectableAttr.resourceId);
            }
        }

        private final void setProtocolImage(ProtocolResources resources) {
            this.itemBinding.ssl.setImageDrawable(AppCompatResources.getDrawable((Context)this.itemView.getContext(), (int)resources.getIcon()));
            ImageViewCompat.setImageTintList((ImageView)this.itemBinding.ssl, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.itemView.getContext(), (int)resources.getColor())));
        }

        private final void setStatusColor(HttpTransactionTuple transaction) {
            int n;
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                n = TransactionAdapter.this.colorError;
            } else if (transaction.getStatus() == HttpTransaction.Status.Requested) {
                n = TransactionAdapter.this.colorRequested;
            } else if (transaction.getResponseCode() == null) {
                n = TransactionAdapter.this.colorDefault;
            } else {
                Integer n2 = transaction.getResponseCode();
                Intrinsics.checkNotNull((Object)n2);
                if (n2 >= 500) {
                    n = TransactionAdapter.this.color500;
                } else {
                    Integer n3 = transaction.getResponseCode();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n3 >= 400) {
                        n = TransactionAdapter.this.color400;
                    } else {
                        Integer n4 = transaction.getResponseCode();
                        Intrinsics.checkNotNull((Object)n4);
                        n = n4 >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault;
                    }
                }
            }
            int color2 = n;
            this.itemBinding.code.setTextColor(color2);
            this.itemBinding.path.setTextColor(color2);
        }

        private static final void _init_$lambda$0(TransactionViewHolder this$0, TransactionAdapter this$1, View it) {
            Long l = this$0.transactionId;
            if (l == null) {
                return;
            }
            long id2 = l;
            if (this$1.isSelectionMode) {
                this$1.onTransactionLongClick.invoke((Object)id2);
                this$0.toggleSelection(id2);
            } else {
                this$1.onTransactionClick.invoke((Object)id2);
            }
        }

        private static final boolean _init_$lambda$1(TransactionViewHolder this$0, TransactionAdapter this$1, View it) {
            Long l = this$0.transactionId;
            if (l == null) {
                return false;
            }
            long id2 = l;
            this$1.onTransactionLongClick.invoke((Object)id2);
            this$0.toggleSelection(id2);
            return true;
        }
    }
}

