/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionDatabaseRepository;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\bH\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/RepositoryProvider;", "", "<init>", "()V", "transactionRepository", "Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionRepository;", "transaction", "initialize", "", "applicationContext", "Landroid/content/Context;", "close", "com.github.ChuckerTeam.Chucker.library"})
public final class RepositoryProvider {
    @NotNull
    public static final RepositoryProvider INSTANCE = new RepositoryProvider();
    @Nullable
    private static HttpTransactionRepository transactionRepository;

    private RepositoryProvider() {
    }

    @NotNull
    public final HttpTransactionRepository transaction() {
        HttpTransactionRepository httpTransactionRepository = transactionRepository;
        if (httpTransactionRepository == null) {
            boolean bl = false;
            String string2 = "You can't access the transaction repository if you don't initialize it!";
            throw new IllegalStateException(string2.toString());
        }
        return httpTransactionRepository;
    }

    public final void initialize(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (transactionRepository == null) {
            ChuckerDatabase db = ChuckerDatabase.Companion.create(applicationContext);
            transactionRepository = new HttpTransactionDatabaseRepository(db);
        }
    }

    @VisibleForTesting
    public final void close() {
        transactionRepository = null;
    }
}

