/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerListItemTransactionBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.support.TransactionDiffCallback;
import com.chuckerteam.chucker.internal.ui.transaction.ProtocolResources;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapterKt;
import java.text.DateFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0001\u0019B#\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0012\u001a\u00020\t2\n\u0010\u0013\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u001c\u0010\u0015\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "context", "Landroid/content/Context;", "onTransactionClick", "Lkotlin/Function1;", "", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "color300", "", "color400", "color500", "colorDefault", "colorError", "colorRequested", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "TransactionViewHolder", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionAdapter
extends ListAdapter<HttpTransactionTuple, TransactionViewHolder> {
    @NotNull
    private final Function1<Long, Unit> onTransactionClick;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;

    public TransactionAdapter(@NotNull Context context, @NotNull Function1<? super Long, Unit> onTransactionClick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onTransactionClick, (String)"onTransactionClick");
        super((DiffUtil.ItemCallback)TransactionDiffCallback.INSTANCE);
        this.onTransactionClick = onTransactionClick;
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_300);
    }

    @NotNull
    public TransactionViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ChuckerListItemTransactionBinding chuckerListItemTransactionBinding = ChuckerListItemTransactionBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerListItemTransactionBinding, (String)"inflate(\n            Lay\u2026          false\n        )");
        ChuckerListItemTransactionBinding viewBinding = chuckerListItemTransactionBinding;
        return new TransactionViewHolder(viewBinding);
    }

    public void onBindViewHolder(@NotNull TransactionViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Object object = this.getItem(position);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(position)");
        holder.bind((HttpTransactionTuple)object);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;", "(Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;)V", "transactionId", "", "Ljava/lang/Long;", "bind", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "setProtocolImage", "resources", "Lcom/chuckerteam/chucker/internal/ui/transaction/ProtocolResources;", "setStatusColor", "com.github.ChuckerTeam.Chucker.library"})
    public final class TransactionViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ChuckerListItemTransactionBinding itemBinding;
        @Nullable
        private Long transactionId;

        public TransactionViewHolder(ChuckerListItemTransactionBinding itemBinding) {
            Intrinsics.checkNotNullParameter((Object)itemBinding, (String)"itemBinding");
            super((View)itemBinding.getRoot());
            this.itemBinding = itemBinding;
            this.itemView.setOnClickListener(arg_0 -> TransactionViewHolder._init_$lambda$1(this, TransactionAdapter.this, arg_0));
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@NotNull HttpTransactionTuple transaction) {
            ChuckerListItemTransactionBinding chuckerListItemTransactionBinding;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            this.transactionId = transaction.getId();
            ChuckerListItemTransactionBinding $this$bind_u24lambda_u242 = chuckerListItemTransactionBinding = this.itemBinding;
            boolean bl = false;
            TransactionAdapterKt.access$displayGraphQlFields($this$bind_u24lambda_u242, transaction.getGraphQlOperationName(), transaction.getGraphQlDetected());
            $this$bind_u24lambda_u242.path.setText((CharSequence)(transaction.getMethod() + " " + transaction.getFormattedPath(false)));
            $this$bind_u24lambda_u242.host.setText((CharSequence)transaction.getHost());
            $this$bind_u24lambda_u242.timeStart.setText((CharSequence)DateFormat.getTimeInstance().format(transaction.getRequestDate()));
            this.setProtocolImage(transaction.isSsl() ? (ProtocolResources)new ProtocolResources.Https() : (ProtocolResources)new ProtocolResources.Http());
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                $this$bind_u24lambda_u242.code.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                $this$bind_u24lambda_u242.duration.setText((CharSequence)transaction.getDurationString());
                $this$bind_u24lambda_u242.size.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                $this$bind_u24lambda_u242.code.setText((CharSequence)"");
                $this$bind_u24lambda_u242.duration.setText((CharSequence)"");
                $this$bind_u24lambda_u242.size.setText((CharSequence)"");
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                $this$bind_u24lambda_u242.code.setText((CharSequence)"!!!");
            }
            this.setStatusColor(transaction);
        }

        private final void setProtocolImage(ProtocolResources resources) {
            this.itemBinding.ssl.setImageDrawable(AppCompatResources.getDrawable((Context)this.itemView.getContext(), (int)resources.getIcon()));
            ImageViewCompat.setImageTintList((ImageView)this.itemBinding.ssl, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.itemView.getContext(), (int)resources.getColor())));
        }

        private final void setStatusColor(HttpTransactionTuple transaction) {
            int n;
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                n = TransactionAdapter.this.colorError;
            } else if (transaction.getStatus() == HttpTransaction.Status.Requested) {
                n = TransactionAdapter.this.colorRequested;
            } else if (transaction.getResponseCode() == null) {
                n = TransactionAdapter.this.colorDefault;
            } else {
                Integer n2 = transaction.getResponseCode();
                Intrinsics.checkNotNull((Object)n2);
                if (n2 >= 500) {
                    n = TransactionAdapter.this.color500;
                } else {
                    Integer n3 = transaction.getResponseCode();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n3 >= 400) {
                        n = TransactionAdapter.this.color400;
                    } else {
                        Integer n4 = transaction.getResponseCode();
                        Intrinsics.checkNotNull((Object)n4);
                        n = n4 >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault;
                    }
                }
            }
            int color2 = n;
            this.itemBinding.code.setTextColor(color2);
            this.itemBinding.path.setTextColor(color2);
        }

        private static final void _init_$lambda$1(TransactionViewHolder this$0, TransactionAdapter this$1, View it) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                Long l = this$0.transactionId;
                if (l == null) break block0;
                long it2 = ((Number)l).longValue();
                boolean bl = false;
                this$1.onTransactionClick.invoke((Object)it2);
            }
        }
    }
}

