/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.LongSparseArray;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.ClearDatabaseJobIntentServiceReceiver;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "notificationManager", "Landroid/app/NotificationManager;", "transactionsScreenIntent", "Landroid/app/PendingIntent;", "kotlin.jvm.PlatformType", "getTransactionsScreenIntent", "()Landroid/app/PendingIntent;", "transactionsScreenIntent$delegate", "Lkotlin/Lazy;", "addToBuffer", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "canShowNotifications", "", "createClearAction", "Landroidx/core/app/NotificationCompat$Action;", "dismissNotifications", "immutableFlag", "", "show", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nNotificationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationHelper.kt\ncom/chuckerteam/chucker/internal/support/NotificationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1855#2,2:149\n*S KotlinDebug\n*F\n+ 1 NotificationHelper.kt\ncom/chuckerteam/chucker/internal/support/NotificationHelper\n*L\n100#1:149,2\n*E\n"})
public final class NotificationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final Lazy transactionsScreenIntent$delegate;
    @NotNull
    private static final String TRANSACTIONS_CHANNEL_ID = "chucker_transactions";
    private static final int TRANSACTION_NOTIFICATION_ID = 1138;
    private static final int BUFFER_SIZE = 10;
    private static final int INTENT_REQUEST_CODE = 11;
    @NotNull
    private static final LongSparseArray<HttpTransaction> transactionBuffer = new LongSparseArray();
    @NotNull
    private static final HashSet<Long> transactionIdsSet = new HashSet();

    public NotificationHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        this.notificationManager = (NotificationManager)object;
        this.transactionsScreenIntent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PendingIntent>(this){
            final /* synthetic */ NotificationHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final PendingIntent invoke() {
                return PendingIntent.getActivity((Context)this.this$0.getContext(), (int)1138, (Intent)Chucker.getLaunchIntent(this.this$0.getContext()), (int)(0x8000000 | NotificationHelper.access$immutableFlag(this.this$0)));
            }
        }));
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel transactionsChannel = new NotificationChannel(TRANSACTIONS_CHANNEL_ID, (CharSequence)this.context.getString(R.string.chucker_network_notification_category), 2);
            this.notificationManager.createNotificationChannels(CollectionsKt.listOf((Object)transactionsChannel));
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final PendingIntent getTransactionsScreenIntent() {
        Lazy lazy = this.transactionsScreenIntent$delegate;
        return (PendingIntent)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToBuffer(HttpTransaction transaction) {
        if (transaction.getId() == 0L) {
            return;
        }
        LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
        synchronized (longSparseArray) {
            boolean bl = false;
            transactionIdsSet.add(transaction.getId());
            transactionBuffer.put(transaction.getId(), (Object)transaction);
            if (transactionBuffer.size() > 10) {
                transactionBuffer.removeAt(0);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean canShowNotifications() {
        return Build.VERSION.SDK_INT >= 24 ? this.notificationManager.areNotificationsEnabled() : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(@NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.addToBuffer(transaction);
        if (!BaseChuckerActivity.Companion.isInForeground() && this.canShowNotifications()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, TRANSACTIONS_CHANNEL_ID).setContentIntent(this.getTransactionsScreenIntent()).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_transaction_notification).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_color_primary)).setContentTitle((CharSequence)this.context.getString(R.string.chucker_http_notification_title)).setAutoCancel(true).addAction(this.createClearAction());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, TRANSAC\u2026tion(createClearAction())");
            NotificationCompat.Builder builder2 = builder;
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
            synchronized (longSparseArray) {
                boolean bl = false;
                int count = 0;
                Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)(transactionBuffer.size() - 1), (int)0);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    HttpTransaction bufferedTransaction = (HttpTransaction)transactionBuffer.valueAt(i);
                    if (bufferedTransaction != null && count < 10) {
                        if (count == 0) {
                            builder2.setContentText((CharSequence)bufferedTransaction.getNotificationText());
                        }
                        inboxStyle.addLine((CharSequence)bufferedTransaction.getNotificationText());
                    }
                    ++count;
                }
                builder2.setStyle((NotificationCompat.Style)inboxStyle);
                NotificationCompat.Builder builder3 = Build.VERSION.SDK_INT >= 24 ? builder2.setSubText((CharSequence)String.valueOf(transactionIdsSet.size())) : builder2.setNumber(transactionIdsSet.size());
            }
            this.notificationManager.notify(1138, builder2.build());
        }
    }

    private final NotificationCompat.Action createClearAction() {
        String string2 = this.context.getString(R.string.chucker_clear);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.chucker_clear)");
        String clearTitle = string2;
        Intent clearTransactionsBroadcastIntent = new Intent(this.context, ClearDatabaseJobIntentServiceReceiver.class);
        PendingIntent pendingBroadcastIntent = PendingIntent.getBroadcast((Context)this.context, (int)11, (Intent)clearTransactionsBroadcastIntent, (int)(0x40000000 | this.immutableFlag()));
        return new NotificationCompat.Action(R.drawable.chucker_ic_delete_white, (CharSequence)clearTitle, pendingBroadcastIntent);
    }

    public final void dismissNotifications() {
        this.notificationManager.cancel(1138);
    }

    private final int immutableFlag() {
        return Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0;
    }

    public static final /* synthetic */ int access$immutableFlag(NotificationHelper $this) {
        return $this.immutableFlag();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper$Companion;", "", "()V", "BUFFER_SIZE", "", "INTENT_REQUEST_CODE", "TRANSACTIONS_CHANNEL_ID", "", "TRANSACTION_NOTIFICATION_ID", "transactionBuffer", "Landroid/util/LongSparseArray;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "transactionIdsSet", "Ljava/util/HashSet;", "", "clearBuffer", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearBuffer() {
            LongSparseArray longSparseArray = transactionBuffer;
            synchronized (longSparseArray) {
                boolean bl = false;
                transactionBuffer.clear();
                transactionIdsSet.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

