/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class HttpTransactionDao_Impl
implements HttpTransactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<HttpTransaction> __insertionAdapterOfHttpTransaction;
    private final EntityDeletionOrUpdateAdapter<HttpTransaction> __updateAdapterOfHttpTransaction;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBefore;

    public HttpTransactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHttpTransaction = new EntityInsertionAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `transactions` (`id`,`requestDate`,`responseDate`,`tookMs`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`responseTlsVersion`,`responseCipherSuite`,`requestContentLength`,`requestContentType`,`requestHeaders`,`requestBody`,`isRequestBodyPlainText`,`responseCode`,`responseMessage`,`error`,`responseContentLength`,`responseContentType`,`responseHeaders`,`responseBody`,`isResponseBodyPlainText`,`responseImageData`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                if (value.getRequestDate() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, value.getRequestDate().longValue());
                }
                if (value.getResponseDate() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, value.getResponseDate().longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getResponseTlsVersion() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getResponseTlsVersion());
                }
                if (value.getResponseCipherSuite() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getResponseCipherSuite());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestContentType());
                }
                if (value.getRequestHeaders() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getRequestHeaders());
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getRequestBody());
                }
                int _tmp = value.isRequestBodyPlainText() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindLong(18, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindLong(21, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseContentType());
                }
                if (value.getResponseHeaders() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getResponseHeaders());
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, value.getResponseBody());
                }
                int _tmp_1 = value.isResponseBodyPlainText() ? 1 : 0;
                stmt.bindLong(25, (long)_tmp_1);
                if (value.getResponseImageData() == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindBlob(26, value.getResponseImageData());
                }
            }
        };
        this.__updateAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `transactions` SET `id` = ?,`requestDate` = ?,`responseDate` = ?,`tookMs` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`requestContentLength` = ?,`requestContentType` = ?,`requestHeaders` = ?,`requestBody` = ?,`isRequestBodyPlainText` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ?,`responseContentLength` = ?,`responseContentType` = ?,`responseHeaders` = ?,`responseBody` = ?,`isResponseBodyPlainText` = ?,`responseImageData` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                if (value.getRequestDate() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, value.getRequestDate().longValue());
                }
                if (value.getResponseDate() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, value.getResponseDate().longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getResponseTlsVersion() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getResponseTlsVersion());
                }
                if (value.getResponseCipherSuite() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getResponseCipherSuite());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestContentType());
                }
                if (value.getRequestHeaders() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getRequestHeaders());
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getRequestBody());
                }
                int _tmp = value.isRequestBodyPlainText() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindLong(18, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindLong(21, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseContentType());
                }
                if (value.getResponseHeaders() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getResponseHeaders());
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, value.getResponseBody());
                }
                int _tmp_1 = value.isResponseBodyPlainText() ? 1 : 0;
                stmt.bindLong(25, (long)_tmp_1);
                if (value.getResponseImageData() == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindBlob(26, value.getResponseImageData());
                }
                stmt.bindLong(27, value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM transactions";
                return "DELETE FROM transactions";
            }
        };
        this.__preparedStmtOfDeleteBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM transactions WHERE requestDate <= ?";
                return "DELETE FROM transactions WHERE requestDate <= ?";
            }
        };
    }

    @Override
    public Object insert(final HttpTransaction transaction, Continuation<? super Long> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                HttpTransactionDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = HttpTransactionDao_Impl.this.__insertionAdapterOfHttpTransaction.insertAndReturnId((Object)transaction);
                    HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(HttpTransaction transaction) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfHttpTransaction.handle((Object)transaction);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object deleteAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = HttpTransactionDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                HttpTransactionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                    HttpTransactionDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object deleteBefore(final long threshold, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = HttpTransactionDao_Impl.this.__preparedStmtOfDeleteBefore.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, threshold);
                HttpTransactionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    HttpTransactionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HttpTransactionDao_Impl.this.__db.endTransaction();
                    HttpTransactionDao_Impl.this.__preparedStmtOfDeleteBefore.release(_stmt);
                }
            }
        }, p1);
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getSortedTuples() {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions ORDER BY requestDate DESC", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<List<HttpTransactionTuple>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HttpTransactionTuple> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestContentLength, _tmpResponseContentLength, _tmpError);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getFilteredTuples(String codeQuery, String pathQuery) {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions WHERE responseCode LIKE ? AND path LIKE ? ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions WHERE responseCode LIKE ? AND path LIKE ? ORDER BY requestDate DESC", (int)2);
        int _argIndex = 1;
        if (codeQuery == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, codeQuery);
        }
        _argIndex = 2;
        if (pathQuery == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pathQuery);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<List<HttpTransactionTuple>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HttpTransactionTuple> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestContentLength, _tmpResponseContentLength, _tmpError);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<HttpTransaction> getById(long id2) {
        String _sql = "SELECT * FROM transactions WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transactions WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"transactions"}, false, (Callable)new Callable<HttpTransaction>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpTransaction call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HttpTransactionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    HttpTransaction _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tookMs");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfIsRequestBodyPlainText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRequestBodyPlainText");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfIsResponseBodyPlainText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isResponseBodyPlainText");
                    int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseImageData");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpResponseDate = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        String _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        String _tmpRequestHeaders = _cursor.getString(_cursorIndexOfRequestHeaders);
                        String _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyPlainText);
                        boolean _tmpIsRequestBodyPlainText = _tmp != 0;
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                        String _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyPlainText);
                        boolean _tmpIsResponseBodyPlainText = _tmp_1 != 0;
                        byte[] _tmpResponseImageData = _cursor.getBlob(_cursorIndexOfResponseImageData);
                        _result = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestContentLength, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestBody, _tmpIsRequestBodyPlainText, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponseContentLength, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseBody, _tmpIsResponseBodyPlainText, _tmpResponseImageData);
                    } else {
                        _result = null;
                    }
                    HttpTransaction httpTransaction = _result;
                    return httpTransaction;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

