/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.chuckerteam.chucker.api.RetentionManager$WhenMappings;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\r\u0010\u000f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager;", "", "context", "Landroid/content/Context;", "retentionPeriod", "Lcom/chuckerteam/chucker/api/RetentionManager$Period;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/RetentionManager$Period;)V", "cleanupFrequency", "", "period", "prefs", "Landroid/content/SharedPreferences;", "deleteSince", "", "threshold", "doMaintenance", "doMaintenance$com_github_ChuckerTeam_Chucker_library", "getLastCleanup", "fallback", "getThreshold", "now", "isCleanupDue", "", "toMillis", "updateLastCleanup", "time", "Companion", "Period", "com.github.ChuckerTeam.Chucker.library"})
public final class RetentionManager {
    private final long period;
    private final long cleanupFrequency;
    private final SharedPreferences prefs;
    private static final String PREFS_NAME = "chucker_preferences";
    private static final String KEY_LAST_CLEANUP = "last_cleanup";
    private static long lastCleanup;
    public static final Companion Companion;

    public final synchronized void doMaintenance$com_github_ChuckerTeam_Chucker_library() {
        long now;
        if (this.period > 0L && this.isCleanupDue(now = System.currentTimeMillis())) {
            Log.i((String)"Chucker", (String)"Performing data retention maintenance...");
            this.deleteSince(this.getThreshold(now));
            this.updateLastCleanup(now);
        }
    }

    private final long getLastCleanup(long fallback) {
        if (lastCleanup == 0L) {
            lastCleanup = this.prefs.getLong(KEY_LAST_CLEANUP, fallback);
        }
        return lastCleanup;
    }

    private final void updateLastCleanup(long time) {
        lastCleanup = time;
        this.prefs.edit().putLong(KEY_LAST_CLEANUP, time).apply();
    }

    private final void deleteSince(long threshold) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(threshold, null){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ long $threshold;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$launch = this.p$;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = RepositoryProvider.INSTANCE.transaction().deleteOldTransactions(this.$threshold, (Continuation<? super Unit>)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = $this$launch;
                        this.label = 2;
                        v1 = RepositoryProvider.INSTANCE.throwable().deleteOldThrowables(this.$threshold, (Continuation<? super Unit>)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$threshold = l;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean isCleanupDue(long now) {
        return now - this.getLastCleanup(now) > this.cleanupFrequency;
    }

    private final long getThreshold(long now) {
        return this.period == 0L ? now : now - this.period;
    }

    private final long toMillis(Period period) {
        long l;
        switch (RetentionManager$WhenMappings.$EnumSwitchMapping$0[period.ordinal()]) {
            case 1: {
                l = TimeUnit.HOURS.toMillis(1L);
                break;
            }
            case 2: {
                l = TimeUnit.DAYS.toMillis(1L);
                break;
            }
            case 3: {
                l = TimeUnit.DAYS.toMillis(7L);
                break;
            }
            case 4: {
                l = 0L;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    @JvmOverloads
    public RetentionManager(@NotNull Context context, @NotNull Period retentionPeriod) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)retentionPeriod), (String)"retentionPeriod");
        this.period = this.toMillis(retentionPeriod);
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_NAME, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPreferences(PREFS_NAME, 0)");
        this.prefs = sharedPreferences;
        this.cleanupFrequency = retentionPeriod == Period.ONE_HOUR ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.HOURS.toMillis(2L);
    }

    public /* synthetic */ RetentionManager(Context context, Period period, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            period = Period.ONE_WEEK;
        }
        this(context, period);
    }

    @JvmOverloads
    public RetentionManager(@NotNull Context context) {
        this(context, null, 2, null);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager$Period;", "", "(Ljava/lang/String;I)V", "ONE_HOUR", "ONE_DAY", "ONE_WEEK", "FOREVER", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Period
    extends Enum<Period> {
        public static final /* enum */ Period ONE_HOUR;
        public static final /* enum */ Period ONE_DAY;
        public static final /* enum */ Period ONE_WEEK;
        public static final /* enum */ Period FOREVER;
        private static final /* synthetic */ Period[] $VALUES;

        static {
            Period[] periodArray = new Period[4];
            Period[] periodArray2 = periodArray;
            periodArray[0] = ONE_HOUR = new Period();
            periodArray[1] = ONE_DAY = new Period();
            periodArray[2] = ONE_WEEK = new Period();
            periodArray[3] = FOREVER = new Period();
            $VALUES = periodArray;
        }

        public static Period[] values() {
            return (Period[])$VALUES.clone();
        }

        public static Period valueOf(String string2) {
            return Enum.valueOf(Period.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager$Companion;", "", "()V", "KEY_LAST_CLEANUP", "", "PREFS_NAME", "lastCleanup", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

