/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.AndroidCacheFileFactory;
import com.chuckerteam.chucker.internal.support.FileFactory;
import com.chuckerteam.chucker.internal.support.IOUtils;
import com.chuckerteam.chucker.internal.support.OkHttpUtilsKt;
import com.chuckerteam.chucker.internal.support.TeeSource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0002)*B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010!\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001f\u0010%\u001a\u00020\u001e2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0'\"\u00020\n\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "maxContentLength", "", "headersToRedact", "", "", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLjava/util/Set;)V", "fileFactory", "Lcom/chuckerteam/chucker/internal/support/FileFactory;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLcom/chuckerteam/chucker/internal/support/FileFactory;Ljava/util/Set;)V", "", "io", "Lcom/chuckerteam/chucker/internal/support/IOUtils;", "filterHeaders", "Lokhttp3/Headers;", "headers", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "multiCastResponseBody", "response", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "processRequest", "", "request", "Lokhttp3/Request;", "processResponseBody", "responseBodyBuffer", "Lokio/Buffer;", "processResponseMetadata", "redactHeader", "headerName", "", "([Ljava/lang/String;)V", "ChuckerTransactionTeeCallback", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class ChuckerInterceptor
implements Interceptor {
    private final IOUtils io;
    private final Set<String> headersToRedact;
    private final Context context;
    private final ChuckerCollector collector;
    private final long maxContentLength;
    private final FileFactory fileFactory;
    private static final Charset UTF8;
    private static final long MAX_BLOB_SIZE = 1000000L;
    private static final String CONTENT_TYPE_IMAGE = "image";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    public static final Companion Companion;

    public final void redactHeader(String ... headerName) {
        Intrinsics.checkParameterIsNotNull((Object)headerName, (String)"headerName");
        CollectionsKt.addAll((Collection)this.headersToRedact, (Object[])headerName);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        HttpTransaction transaction = new HttpTransaction();
        Request request2 = request;
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        this.processRequest(request2, transaction);
        this.collector.onRequestSent$com_github_ChuckerTeam_Chucker_library(transaction);
        try {
            Response response2 = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
            response = response2;
        }
        catch (IOException e) {
            transaction.setError(e.toString());
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            throw (Throwable)e;
        }
        this.processResponseMetadata(response, transaction);
        return this.multiCastResponseBody(response, transaction);
    }

    private final void processRequest(Request request, HttpTransaction transaction) {
        RequestBody requestBody = request.body();
        boolean encodingIsSupported = this.io.bodyHasSupportedEncoding(request.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = request.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"request.headers()");
        $this$apply.setRequestHeaders(headers);
        HttpUrl httpUrl = request.url();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"request.url()");
        $this$apply.populateUrl(httpUrl);
        $this$apply.setRequestBodyPlainText(encodingIsSupported);
        $this$apply.setRequestDate(System.currentTimeMillis());
        $this$apply.setMethod(request.method());
        RequestBody requestBody2 = requestBody;
        $this$apply.setRequestContentType(requestBody2 != null && (requestBody2 = requestBody2.contentType()) != null ? requestBody2.toString() : null);
        RequestBody requestBody3 = requestBody;
        $this$apply.setRequestContentLength(requestBody3 != null ? requestBody3.contentLength() : 0L);
        if (requestBody != null && encodingIsSupported) {
            BufferedSource source = this.io.getNativeSource((BufferedSource)new Buffer(), OkHttpUtilsKt.isGzipped(request));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF8");
            Charset charset2 = charset;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                Charset charset3 = contentType.charset(UTF8);
                if (charset3 == null) {
                    Charset charset4 = UTF8;
                    charset3 = charset4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset4, (String)"UTF8");
                }
                charset2 = charset3;
            }
            Buffer buffer2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)buffer2, (String)"buffer");
            if (this.io.isPlaintext(buffer2)) {
                String content = this.io.readFromBuffer(buffer, charset2, this.maxContentLength);
                transaction.setRequestBody(content);
            } else {
                transaction.setResponseBodyPlainText(false);
            }
        }
    }

    private final void processResponseMetadata(Response response, HttpTransaction transaction) {
        boolean responseEncodingIsSupported = this.io.bodyHasSupportedEncoding(response.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = response.request().headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"response.request().headers()");
        $this$apply.setRequestHeaders(this.filterHeaders(headers));
        Headers headers2 = response.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"response.headers()");
        $this$apply.setResponseHeaders(this.filterHeaders(headers2));
        $this$apply.setResponseBodyPlainText(responseEncodingIsSupported);
        $this$apply.setRequestDate(response.sentRequestAtMillis());
        $this$apply.setResponseDate(response.receivedResponseAtMillis());
        $this$apply.setProtocol(response.protocol().toString());
        $this$apply.setResponseCode(response.code());
        $this$apply.setResponseMessage(response.message());
        Handshake handshake = response.handshake();
        if (handshake != null) {
            Handshake handshake2 = handshake;
            boolean bl4 = false;
            boolean bl5 = false;
            Handshake handshake3 = handshake2;
            boolean bl6 = false;
            $this$apply.setResponseTlsVersion(handshake3.tlsVersion().javaName());
            $this$apply.setResponseCipherSuite(handshake3.cipherSuite().javaName());
        }
        $this$apply.setResponseContentType(OkHttpUtilsKt.getContentType(response));
        $this$apply.setResponseContentLength(OkHttpUtilsKt.getContentLength(response));
        $this$apply.setTookMs(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
    }

    private final Response multiCastResponseBody(Response response, HttpTransaction transaction) {
        ResponseBody responseBody = response.body();
        if (!OkHttpUtilsKt.hasBody(response) || responseBody == null) {
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            return response;
        }
        MediaType contentType = responseBody.contentType();
        long contentLength = responseBody.contentLength();
        BufferedSource bufferedSource = responseBody.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"responseBody.source()");
        TeeSource teeSource = new TeeSource((Source)bufferedSource, this.fileFactory.create(), new ChuckerTransactionTeeCallback(response, transaction), this.maxContentLength);
        Response response2 = response.newBuilder().body(ResponseBody.create((MediaType)contentType, (long)contentLength, (BufferedSource)Okio.buffer((Source)teeSource))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.newBuilder()\n  \u2026e)))\n            .build()");
        return response2;
    }

    private final void processResponseBody(Response response, Buffer responseBodyBuffer, HttpTransaction transaction) {
        Object charset;
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"response.body() ?: return");
        ResponseBody responseBody2 = responseBody;
        MediaType contentType = responseBody2.contentType();
        Object object = contentType;
        if (object == null || (object = object.charset(UTF8)) == null) {
            object = charset = UTF8;
        }
        if (this.io.isPlaintext(responseBodyBuffer)) {
            transaction.setResponseBodyPlainText(true);
            if (responseBodyBuffer.size() != 0L) {
                transaction.setResponseBody(responseBodyBuffer.readString((Charset)charset));
            }
        } else {
            boolean isImageContentType;
            transaction.setResponseBodyPlainText(false);
            Object object2 = contentType;
            boolean bl = object2 != null && (object2 = object2.toString()) != null && StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)CONTENT_TYPE_IMAGE, (boolean)true) ? true : (isImageContentType = false);
            if (isImageContentType && responseBodyBuffer.size() < 1000000L) {
                transaction.setResponseImageData(responseBodyBuffer.readByteArray());
            }
        }
    }

    private final Headers filterHeaders(Headers headers) {
        Headers.Builder builder = headers.newBuilder();
        for (String name : headers.names()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.headersToRedact;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String userHeader = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)userHeader, (String)name, (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            builder.set(name, "**");
        }
        Headers headers2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"builder.build()");
        return headers2;
    }

    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull FileFactory fileFactory, @NotNull Set<String> headersToRedact) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)fileFactory, (String)"fileFactory");
        Intrinsics.checkParameterIsNotNull(headersToRedact, (String)"headersToRedact");
        this.context = context;
        this.collector = collector;
        this.maxContentLength = maxContentLength;
        this.fileFactory = fileFactory;
        this.io = new IOUtils(this.context);
        this.headersToRedact = CollectionsKt.toMutableSet((Iterable)headersToRedact);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, FileFactory fileFactory, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        this(context, chuckerCollector, l, fileFactory, set);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(headersToRedact, (String)"headersToRedact");
        this(context, collector, maxContentLength, new AndroidCacheFileFactory(context), headersToRedact);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(context, chuckerCollector, l, set);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength) {
        this(context, collector, maxContentLength, null, 8, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector) {
        this(context, collector, 0L, null, 12, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context) {
        this(context, null, 0L, null, 14, null);
    }

    static {
        Companion = new Companion(null);
        UTF8 = Charset.forName("UTF-8");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$ChuckerTransactionTeeCallback;", "Lcom/chuckerteam/chucker/internal/support/TeeSource$Callback;", "response", "Lokhttp3/Response;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "(Lcom/chuckerteam/chucker/api/ChuckerInterceptor;Lokhttp3/Response;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;)V", "onFailure", "", "exception", "Ljava/io/IOException;", "file", "Ljava/io/File;", "onSuccess", "readResponseBuffer", "Lokio/Buffer;", "responseBody", "isGzipped", "", "com.github.ChuckerTeam.Chucker.library"})
    private final class ChuckerTransactionTeeCallback
    implements TeeSource.Callback {
        private final Response response;
        private final HttpTransaction transaction;

        @Override
        public void onSuccess(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Buffer buffer = this.readResponseBuffer(file, OkHttpUtilsKt.isGzipped(this.response));
            file.delete();
            if (buffer != null) {
                ChuckerInterceptor.this.processResponseBody(this.response, buffer, this.transaction);
            }
            ChuckerInterceptor.this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(this.transaction);
        }

        @Override
        public void onFailure(@NotNull IOException exception, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            file.delete();
            ChuckerInterceptor.this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(this.transaction);
        }

        private final Buffer readResponseBuffer(File responseBody, boolean isGzipped) {
            Buffer buffer;
            BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((File)responseBody));
            Source source = isGzipped ? (Source)new GzipSource((Source)bufferedSource) : (Source)bufferedSource;
            try {
                buffer = new Buffer();
                boolean bl = false;
                boolean bl2 = false;
                Buffer $this$apply = buffer;
                boolean bl3 = false;
                $this$apply.writeAll(source);
            }
            catch (IOException _) {
                buffer = null;
            }
            return buffer;
        }

        public ChuckerTransactionTeeCallback(@NotNull Response response, HttpTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.response = response;
            this.transaction = transaction;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Companion;", "", "()V", "CONTENT_ENCODING", "", "CONTENT_TYPE_IMAGE", "MAX_BLOB_SIZE", "", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

