/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import java.io.EOFException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/chuckerteam/chucker/internal/support/IOUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bodyHasSupportedEncoding", "", "contentEncoding", "", "getNativeSource", "Lokio/BufferedSource;", "input", "isGzipped", "isPlaintext", "buffer", "Lokio/Buffer;", "readFromBuffer", "charset", "Ljava/nio/charset/Charset;", "maxContentLength", "", "com.github.ChuckerTeam.Chucker.library"})
public final class IOUtils {
    private final Context context;

    /*
     * WARNING - void declaration
     */
    public final boolean isPlaintext(@NotNull Buffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            int n = 0;
            int n2 = 16;
            while (n < n2 && !prefix.exhausted()) {
                void i;
                int codePoint = prefix.readUtf8CodePoint();
                if (Character.isISOControl(codePoint) && !Character.isWhitespace(codePoint)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    @NotNull
    public final String readFromBuffer(@NotNull Buffer buffer, @NotNull Charset charset, long maxContentLength) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        long bufferSize = buffer.size();
        boolean bl = false;
        long maxBytes = Math.min(bufferSize, maxContentLength);
        String body = "";
        try {
            String string2 = buffer.readString(maxBytes, charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buffer.readString(maxBytes, charset)");
            body = string2;
        }
        catch (EOFException e) {
            body = body + this.context.getString(R.string.chucker_body_unexpected_eof);
        }
        if (bufferSize > maxContentLength) {
            body = body + this.context.getString(R.string.chucker_body_content_truncated);
        }
        return body;
    }

    @NotNull
    public final BufferedSource getNativeSource(@NotNull BufferedSource input, boolean isGzipped) {
        BufferedSource bufferedSource;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (isGzipped) {
            GzipSource source = new GzipSource((Source)input);
            BufferedSource bufferedSource2 = Okio.buffer((Source)((Source)source));
            bufferedSource = bufferedSource2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource2, (String)"Okio.buffer(source)");
        } else {
            bufferedSource = input;
        }
        return bufferedSource;
    }

    public final boolean bodyHasSupportedEncoding(@Nullable String contentEncoding) {
        CharSequence charSequence = contentEncoding;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 || StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) || StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    public IOUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

