/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002\u001d\u001eB\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\tH\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u001c\u0010\u0017\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$ViewHolder;", "context", "Landroid/content/Context;", "listener", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;)V", "color300", "", "color400", "color500", "colorDefault", "colorError", "colorRequested", "transactions", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "getItemCount", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "httpTransactions", "TransactionClickListListener", "ViewHolder", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<HttpTransactionTuple> transactions;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;
    private final TransactionClickListListener listener;

    public int getItemCount() {
        return this.transactions.size();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View itemView;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.chucker_list_item_transaction, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        holder.bind(this.transactions.get(position));
    }

    public final void setData(@NotNull List<HttpTransactionTuple> httpTransactions) {
        Intrinsics.checkParameterIsNotNull(httpTransactions, (String)"httpTransactions");
        this.transactions = httpTransactions;
        this.notifyDataSetChanged();
    }

    public TransactionAdapter(@NotNull Context context, @Nullable TransactionClickListListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.listener = listener;
        TransactionAdapter transactionAdapter = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        transactionAdapter.transactions = arrayList;
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_300);
    }

    public static final /* synthetic */ TransactionClickListListener access$getListener$p(TransactionAdapter $this) {
        return $this.listener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u00020\u00112\n\u0010\u0015\u001a\u00060\u0000R\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;Landroid/view/View;)V", "code", "Landroid/widget/TextView;", "duration", "host", "path", "size", "ssl", "Landroid/widget/ImageView;", "start", "getView", "()Landroid/view/View;", "bind", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "setStatusColor", "holder", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "com.github.ChuckerTeam.Chucker.library"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView code;
        private final TextView path;
        private final TextView host;
        private final TextView start;
        private final TextView duration;
        private final TextView size;
        private final ImageView ssl;
        @NotNull
        private final View view;

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@NotNull HttpTransactionTuple transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.path.setText((CharSequence)(transaction.getMethod() + ' ' + transaction.getPath()));
            this.host.setText((CharSequence)transaction.getHost());
            this.start.setText((CharSequence)DateFormat.getTimeInstance().format(transaction.getRequestDate()));
            this.ssl.setVisibility(transaction.isSsl() ? 0 : 8);
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                this.code.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                this.duration.setText((CharSequence)transaction.getDurationString());
                this.size.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                this.code.setText((CharSequence)"");
                this.duration.setText((CharSequence)"");
                this.size.setText((CharSequence)"");
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                this.code.setText((CharSequence)"!!!");
            }
            this.setStatusColor(this, transaction);
            this.view.setOnClickListener(new View.OnClickListener(this, transaction){
                final /* synthetic */ ViewHolder this$0;
                final /* synthetic */ HttpTransactionTuple $transaction;

                public final void onClick(View it) {
                    block0: {
                        TransactionClickListListener transactionClickListListener = TransactionAdapter.access$getListener$p(this.this$0.TransactionAdapter.this);
                        if (transactionClickListListener == null) break block0;
                        transactionClickListListener.onTransactionClick(this.$transaction.getId(), this.this$0.getAdapterPosition());
                    }
                }
                {
                    this.this$0 = viewHolder;
                    this.$transaction = httpTransactionTuple;
                }
            });
        }

        private final void setStatusColor(ViewHolder holder, HttpTransactionTuple transaction) {
            int n;
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                n = TransactionAdapter.this.colorError;
            } else if (transaction.getStatus() == HttpTransaction.Status.Requested) {
                n = TransactionAdapter.this.colorRequested;
            } else if (transaction.getResponseCode() == null) {
                n = TransactionAdapter.this.colorDefault;
            } else {
                Integer n2 = transaction.getResponseCode();
                if (n2 == null) {
                    Intrinsics.throwNpe();
                }
                if (n2 >= 500) {
                    n = TransactionAdapter.this.color500;
                } else {
                    Integer n3 = transaction.getResponseCode();
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n3 >= 400) {
                        n = TransactionAdapter.this.color400;
                    } else {
                        Integer n4 = transaction.getResponseCode();
                        if (n4 == null) {
                            Intrinsics.throwNpe();
                        }
                        n = n4 >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault;
                    }
                }
            }
            int color2 = n;
            holder.code.setTextColor(color2);
            holder.path.setTextColor(color2);
        }

        @NotNull
        public final View getView() {
            return this.view;
        }

        public ViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            this.view = view;
            View view2 = this.view.findViewById(R.id.chucker_code);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.chucker_code)");
            this.code = (TextView)view2;
            View view3 = this.view.findViewById(R.id.chucker_path);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.chucker_path)");
            this.path = (TextView)view3;
            View view4 = this.view.findViewById(R.id.chucker_host);
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view.findViewById(R.id.chucker_host)");
            this.host = (TextView)view4;
            View view5 = this.view.findViewById(R.id.chucker_time_start);
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"view.findViewById(R.id.chucker_time_start)");
            this.start = (TextView)view5;
            View view6 = this.view.findViewById(R.id.chucker_duration);
            Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"view.findViewById(R.id.chucker_duration)");
            this.duration = (TextView)view6;
            View view7 = this.view.findViewById(R.id.chucker_size);
            Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"view.findViewById(R.id.chucker_size)");
            this.size = (TextView)view7;
            View view8 = this.view.findViewById(R.id.chucker_ssl);
            Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"view.findViewById(R.id.chucker_ssl)");
            this.ssl = (ImageView)view8;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "", "onTransactionClick", "", "transactionId", "", "position", "", "com.github.ChuckerTeam.Chucker.library"})
    public static interface TransactionClickListListener {
        public void onTransactionClick(long var1, int var3);
    }
}

