/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.JsonConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormatUtils;", "", "()V", "BASE_TWO_MULTIPLE", "", "SI_MULTIPLE", "formatByteCount", "", "bytes", "", "si", "", "formatHeaders", "httpHeaders", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "withMarkup", "formatJson", "json", "formatThrowable", "throwable", "", "formatXml", "xml", "getShareCurlCommand", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "getShareText", "context", "Landroid/content/Context;", "com.github.ChuckerTeam.Chucker.library"})
public final class FormatUtils {
    private static final int SI_MULTIPLE = 1000;
    private static final int BASE_TWO_MULTIPLE = 1024;
    public static final FormatUtils INSTANCE;

    @NotNull
    public final String formatHeaders(@Nullable List<HttpHeader> httpHeaders, boolean withMarkup) {
        List<HttpHeader> list = httpHeaders;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<HttpHeader, CharSequence>(withMarkup){
            final /* synthetic */ boolean $withMarkup;

            @NotNull
            public final CharSequence invoke(@NotNull HttpHeader header) {
                Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                return this.$withMarkup ? (CharSequence)("<b> " + header.getName() + ": </b>" + header.getValue() + " <br />") : (CharSequence)(header.getName() + ": " + header.getValue() + '\n');
            }
            {
                this.$withMarkup = bl;
                super(1);
            }
        }), (int)30, null)) == null) {
            list = "";
        }
        return list;
    }

    @NotNull
    public final String formatByteCount(long bytes, boolean si) {
        Object[] objectArray;
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        double d = bytes;
        boolean bl = false;
        double d2 = Math.log(d);
        d = unit;
        double d3 = d2;
        bl = false;
        double d4 = Math.log(d);
        int exp = (int)(d3 / d4);
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        Object object = si ? "" : "i";
        boolean bl2 = false;
        String pre = String.valueOf(c) + (String)object;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        object = locale;
        String string = "%.1f %sB";
        double d5 = unit;
        double d6 = exp;
        double d7 = bytes;
        int n2 = 0;
        Object[] objectArray2 = objectArray = new Object[2];
        boolean bl3 = false;
        double d8 = Math.pow(d5, d6);
        objectArray[n2] = d7 / d8;
        objectArray2[1] = pre;
        Object[] objectArray3 = objectArray2;
        boolean bl4 = false;
        String string2 = String.format((Locale)object, string, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return string2;
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            JsonElement je = JsonParser.parseString((String)json);
            String string2 = JsonConverter.INSTANCE.getInstance().toJson(je);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JsonConverter.instance.toJson(je)");
            string = string2;
        }
        catch (JsonParseException e) {
            string = json;
        }
        return string;
    }

    @NotNull
    public final String formatXml(@NotNull String xml) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)xml, (String)"xml");
        try {
            byte[] byArray;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilderFactory, (String)"DocumentBuilderFactory.newInstance()");
            DocumentBuilderFactory documentFactory = documentBuilderFactory;
            documentFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder, (String)"documentFactory.newDocumentBuilder()");
            DocumentBuilder documentBuilder2 = documentBuilder;
            String string2 = xml;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
            Charset charset2 = charset;
            boolean bl = false;
            byte[] byArray2 = string2.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray = byArray2;
            InputStream inputStream = new ByteArrayInputStream(byArray3);
            InputSource inputSource = new InputSource(inputStream);
            Document document = documentBuilder2.parse(inputSource);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(inputSource)");
            Document document2 = document;
            DOMSource domSource = new DOMSource(document2);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object object = TransformerFactory.newInstance();
            boolean bl2 = false;
            boolean bl3 = false;
            Object $this$apply = object;
            boolean bl4 = false;
            ((TransformerFactory)$this$apply).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            object = ((TransformerFactory)object).newTransformer();
            bl2 = false;
            bl3 = false;
            $this$apply = object;
            boolean bl5 = false;
            ((Transformer)$this$apply).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)$this$apply).setOutputProperty("indent", "yes");
            ((Transformer)$this$apply).transform(domSource, result);
            String string3 = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"writer.toString()");
            string = string3;
        }
        catch (SAXParseException e) {
            string = xml;
        }
        catch (IOException io) {
            string = xml;
        }
        catch (TransformerException t) {
            string = xml;
        }
        return string;
    }

    @NotNull
    public final String getShareText(@NotNull Context context, @NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        String text = context.getString(R.string.chucker_url) + ": " + transaction.getUrl() + '\n';
        text = text + context.getString(R.string.chucker_method) + ": " + transaction.getMethod() + '\n';
        text = text + context.getString(R.string.chucker_protocol) + ": " + transaction.getProtocol() + '\n';
        text = text + context.getString(R.string.chucker_status) + ": " + (Object)((Object)transaction.getStatus()) + '\n';
        text = text + context.getString(R.string.chucker_response) + ": " + transaction.getResponseSummaryText() + '\n';
        text = text + context.getString(R.string.chucker_ssl) + ": " + context.getString(transaction.isSsl() ? R.string.chucker_yes : R.string.chucker_no) + '\n';
        text = text + "\n";
        text = text + context.getString(R.string.chucker_request_time) + ": " + transaction.getRequestDateString() + '\n';
        text = text + context.getString(R.string.chucker_response_time) + ": " + transaction.getResponseDateString() + '\n';
        text = text + context.getString(R.string.chucker_duration) + ": " + transaction.getDurationString() + '\n';
        text = text + "\n";
        text = text + context.getString(R.string.chucker_request_size) + ": " + transaction.getRequestSizeString() + '\n';
        text = text + context.getString(R.string.chucker_response_size) + ": " + transaction.getResponseSizeString() + '\n';
        text = text + context.getString(R.string.chucker_total_size) + ": " + transaction.getTotalSizeString() + '\n';
        text = text + "\n";
        text = text + "---------- " + context.getString(R.string.chucker_request) + " ----------\n\n";
        String headers = this.formatHeaders(transaction.getParsedRequestHeaders(), false);
        CharSequence charSequence = headers;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            text = text + headers + '\n';
        }
        text = text + (transaction.isRequestBodyPlainText() ? transaction.getFormattedRequestBody() : context.getString(R.string.chucker_body_omitted));
        text = text + "\n\n";
        text = text + "---------- " + context.getString(R.string.chucker_response) + " ----------\n\n";
        headers = this.formatHeaders(transaction.getParsedResponseHeaders(), false);
        charSequence = headers;
        bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            text = text + headers + '\n';
        }
        text = text + (transaction.isResponseBodyPlainText() ? transaction.getFormattedResponseBody() : context.getString(R.string.chucker_body_omitted));
        return text;
    }

    @NotNull
    public final String getShareCurlCommand(@NotNull HttpTransaction transaction) {
        List<HttpHeader> headers;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        boolean compressed = false;
        String curlCmd = "curl -X " + transaction + ".method";
        List<HttpHeader> list = headers = transaction.getParsedRequestHeaders();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HttpHeader header = (HttpHeader)element$iv;
                boolean bl = false;
                if (StringsKt.equals((String)"Accept-Encoding", (String)header.getName(), (boolean)true) && StringsKt.equals((String)"gzip", (String)header.getValue(), (boolean)true)) {
                    compressed = true;
                }
                curlCmd = curlCmd + " -H \"" + header + ".name: " + header + ".value\"";
            }
        }
        String requestBody = transaction.getRequestBody();
        CharSequence charSequence = requestBody;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            curlCmd = curlCmd + " --data $'" + requestBody + ".replace(\"\\n\", \"\\\\n\")'";
        }
        curlCmd = curlCmd + (compressed ? " --compressed " : " ") + transaction.getUrl();
        return curlCmd;
    }

    @NotNull
    public final String formatThrowable(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String string2 = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sw.toString()");
        return string2;
    }

    private FormatUtils() {
    }

    static {
        FormatUtils formatUtils;
        INSTANCE = formatUtils = new FormatUtils();
    }
}

