/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.error;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.ShareCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import java.io.Serializable;
import java.text.DateFormat;

public class ErrorActivity
extends AppCompatActivity {
    public static final String EXTRA_ID = "EXTRA_ID";
    private long throwableId;
    private RecordedThrowable throwable;
    private TextView title;
    private TextView tag;
    private TextView clazz;
    private TextView message;
    private TextView date;
    private TextView stacktrace;

    public static void start(Context context, Long id2) {
        Intent intent = new Intent(context, ErrorActivity.class);
        intent.putExtra(EXTRA_ID, (Serializable)id2);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chucker_activity_error);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.title = (TextView)this.findViewById(R.id.toolbar_title);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
        }
        this.tag = (TextView)this.findViewById(R.id.tag);
        this.clazz = (TextView)this.findViewById(R.id.clazz);
        this.message = (TextView)this.findViewById(R.id.message);
        this.date = (TextView)this.findViewById(R.id.date);
        this.stacktrace = (TextView)this.findViewById(R.id.stacktrace);
        this.date.setVisibility(8);
        this.throwableId = this.getIntent().getLongExtra(EXTRA_ID, 0L);
    }

    protected void onResume() {
        super.onResume();
        RepositoryProvider.throwable().getRecordedThrowable(this.throwableId).observe((LifecycleOwner)this, (Observer)new Observer<RecordedThrowable>(){

            public void onChanged(@Nullable RecordedThrowable recordedThrowable) {
                if (recordedThrowable != null) {
                    ErrorActivity.this.populateUI(recordedThrowable);
                    ErrorActivity.this.throwable = recordedThrowable;
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.chucker_error, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.share_text) {
            this.share(this.throwable);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void share(RecordedThrowable throwable) {
        String text = this.getString(R.string.chucker_share_error_content, new Object[]{DateFormat.getDateTimeInstance(3, 2).format(throwable.getDate()), throwable.getClazz(), throwable.getTag(), throwable.getMessage(), throwable.getContent()});
        this.startActivity(ShareCompat.IntentBuilder.from((Activity)this).setType("text/plain").setSubject(this.getString(R.string.chucker_share_error_title)).setText((CharSequence)text).createChooserIntent());
    }

    private void populateUI(RecordedThrowable throwable) {
        String dateStr = DateFormat.getDateTimeInstance(3, 2).format(throwable.getDate());
        this.title.setText((CharSequence)dateStr);
        this.tag.setText((CharSequence)throwable.getTag());
        this.clazz.setText((CharSequence)throwable.getClazz());
        this.message.setText((CharSequence)throwable.getMessage());
        this.stacktrace.setText((CharSequence)throwable.getContent());
    }
}

