/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.transaction;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransactionTuple;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

public class TransactionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final TransactionClickListListener listener;
    private List<HttpTransactionTuple> transactions;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;

    TransactionAdapter(Context context, TransactionClickListListener listener) {
        this.listener = listener;
        this.transactions = new ArrayList<HttpTransactionTuple>();
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_300);
    }

    public int getItemCount() {
        return this.transactions.size();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.chucker_list_item_transaction, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        HttpTransactionTuple transaction = this.transactions.get(position);
        holder.bind(transaction);
    }

    public void setData(List<HttpTransactionTuple> httpTransactions) {
        this.transactions = httpTransactions;
        this.notifyDataSetChanged();
    }

    public static interface TransactionClickListListener {
        public void onTransactionClick(long var1, int var3);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        final View view;
        final TextView code;
        final TextView path;
        final TextView host;
        final TextView start;
        final TextView duration;
        final TextView size;
        final ImageView ssl;

        ViewHolder(View view) {
            super(view);
            this.view = view;
            this.code = (TextView)view.findViewById(R.id.chucker_code);
            this.path = (TextView)view.findViewById(R.id.chucker_path);
            this.host = (TextView)view.findViewById(R.id.chucker_host);
            this.start = (TextView)view.findViewById(R.id.chucker_time_start);
            this.duration = (TextView)view.findViewById(R.id.chucker_duration);
            this.size = (TextView)view.findViewById(R.id.chucker_size);
            this.ssl = (ImageView)view.findViewById(R.id.chucker_ssl);
        }

        void bind(final HttpTransactionTuple transaction) {
            this.path.setText((CharSequence)String.format("%s %s", transaction.getMethod(), transaction.getPath()));
            this.host.setText((CharSequence)transaction.getHost());
            this.start.setText((CharSequence)DateFormat.getTimeInstance().format(transaction.getRequestDate()));
            this.ssl.setVisibility(transaction.isSsl() ? 0 : 8);
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                this.code.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                this.duration.setText((CharSequence)transaction.getDurationString());
                this.size.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                this.code.setText((CharSequence)"");
                this.duration.setText((CharSequence)"");
                this.size.setText((CharSequence)"");
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                this.code.setText((CharSequence)"!!!");
            }
            this.setStatusColor(this, transaction);
            this.view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TransactionAdapter.this.listener != null) {
                        TransactionAdapter.this.listener.onTransactionClick(transaction.getId(), ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }

        private void setStatusColor(ViewHolder holder, HttpTransactionTuple transaction) {
            int color2 = transaction.getStatus() == HttpTransaction.Status.Failed ? TransactionAdapter.this.colorError : (transaction.getStatus() == HttpTransaction.Status.Requested ? TransactionAdapter.this.colorRequested : (transaction.getResponseCode() == null ? TransactionAdapter.this.colorDefault : (transaction.getResponseCode() >= 500 ? TransactionAdapter.this.color500 : (transaction.getResponseCode() >= 400 ? TransactionAdapter.this.color400 : (transaction.getResponseCode() >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault)))));
            holder.code.setTextColor(color2);
            holder.path.setTextColor(color2);
        }
    }
}

