/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import android.util.Log;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.support.IOUtils;
import com.chuckerteam.chucker.api.internal.support.OkHttpUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "maxContentLength", "", "headersToRedact", "", "", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLjava/util/Set;)V", "io", "Lcom/chuckerteam/chucker/api/internal/support/IOUtils;", "filterHeaders", "Lokhttp3/Headers;", "headers", "getNativeSource", "Lokio/BufferedSource;", "response", "Lokhttp3/Response;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "redactHeader", "name", "Companion", "library_release"})
public final class ChuckerInterceptor
implements Interceptor {
    private final IOUtils io;
    private final Context context;
    private final ChuckerCollector collector;
    private final long maxContentLength;
    private final Set<String> headersToRedact;
    private static final Charset UTF8;
    public static final Companion Companion;

    @NotNull
    public final ChuckerInterceptor redactHeader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ChuckerInterceptor chuckerInterceptor = this;
        boolean bl = false;
        boolean bl2 = false;
        ChuckerInterceptor $this$apply = chuckerInterceptor;
        boolean bl3 = false;
        $this$apply.headersToRedact.add(name);
        return chuckerInterceptor;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        RequestBody requestBody = request.body();
        HttpTransaction transaction = new HttpTransaction();
        transaction.setRequestDate(System.currentTimeMillis());
        transaction.setMethod(request.method());
        String string2 = request.url().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.url().toString()");
        transaction.populateUrl(string2);
        Headers headers = request.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"request.headers()");
        transaction.setRequestHeaders(headers);
        RequestBody requestBody2 = requestBody;
        transaction.setRequestContentType(requestBody2 != null && (requestBody2 = requestBody2.contentType()) != null ? requestBody2.toString() : null);
        RequestBody requestBody3 = requestBody;
        transaction.setRequestContentLength(requestBody3 != null ? requestBody3.contentLength() : 0L);
        boolean encodingIsSupported = this.io.bodyHasSupportedEncoding(request.headers().get("Content-Encoding"));
        transaction.setRequestBodyPlainText(encodingIsSupported);
        if (requestBody != null && encodingIsSupported) {
            BufferedSource source = this.io.getNativeSource((BufferedSource)new Buffer(), this.io.bodyIsGzipped(request.headers().get("Content-Encoding")));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (this.io.isPlaintext(buffer)) {
                String content = this.io.readFromBuffer(buffer, charset, this.maxContentLength);
                transaction.setRequestBody(content);
            } else {
                transaction.setResponseBodyPlainText(false);
            }
        }
        this.collector.onRequestSent$library_release(transaction);
        long startNs = System.nanoTime();
        Response response = null;
        try {
            Response response2 = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
            response = response2;
        }
        catch (IOException e) {
            transaction.setError(e.toString());
            this.collector.onResponseReceived$library_release(transaction);
            throw (Throwable)e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Headers headers2 = response.request().headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"response.request().headers()");
        transaction.setRequestHeaders(this.filterHeaders(headers2));
        transaction.setResponseDate(System.currentTimeMillis());
        transaction.setTookMs(tookMs);
        transaction.setProtocol(response.protocol().toString());
        transaction.setResponseCode(response.code());
        transaction.setResponseMessage(response.message());
        ResponseBody responseBody2 = responseBody;
        transaction.setResponseContentType(responseBody2 != null && (responseBody2 = responseBody2.contentType()) != null ? responseBody2.toString() : null);
        ResponseBody responseBody3 = responseBody;
        transaction.setResponseContentLength(responseBody3 != null ? responseBody3.contentLength() : 0L);
        Headers headers3 = response.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers3, (String)"response.headers()");
        transaction.setResponseHeaders(this.filterHeaders(headers3));
        boolean responseEncodingIsSupported = this.io.bodyHasSupportedEncoding(response.headers().get("Content-Encoding"));
        transaction.setResponseBodyPlainText(responseEncodingIsSupported);
        if (OkHttpUtils.hasBody(response) && responseEncodingIsSupported) {
            MediaType contentType;
            BufferedSource source = this.getNativeSource(response);
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            ResponseBody responseBody4 = responseBody;
            Object object = contentType = responseBody4 != null ? responseBody4.contentType() : null;
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.collector.onResponseReceived$library_release(transaction);
                    return response;
                }
            }
            if (this.io.isPlaintext(buffer)) {
                String content = this.io.readFromBuffer(buffer.clone(), charset, this.maxContentLength);
                transaction.setResponseBody(content);
            } else {
                transaction.setResponseBodyPlainText(false);
                String string3 = transaction.getResponseContentType();
                if (string3 != null) {
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"image", (boolean)false, (int)2, null)) {
                        transaction.setResponseImageData(buffer.clone().readByteArray());
                    }
                }
            }
            transaction.setResponseContentLength(buffer.size());
        }
        this.collector.onResponseReceived$library_release(transaction);
        return response;
    }

    private final Headers filterHeaders(Headers headers) {
        Headers.Builder builder = headers.newBuilder();
        for (String name : headers.names()) {
            if (!this.headersToRedact.contains(name)) continue;
            builder.set(name, "**");
        }
        Headers headers2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"builder.build()");
        return headers2;
    }

    private final BufferedSource getNativeSource(Response response) throws IOException {
        if (this.io.bodyIsGzipped(response.headers().get("Content-Encoding"))) {
            BufferedSource source = response.peekBody(this.maxContentLength).source();
            if (source.buffer().size() < this.maxContentLength) {
                BufferedSource bufferedSource = this.io.getNativeSource(source, true);
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"io.getNativeSource(source, true)");
                return bufferedSource;
            }
            Log.w((String)"Chucker", (String)"gzip encoded response was too long");
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource bufferedSource = responseBody.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"response.body()!!.source()");
        return bufferedSource;
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(headersToRedact, (String)"headersToRedact");
        this.context = context;
        this.collector = collector;
        this.maxContentLength = maxContentLength;
        this.headersToRedact = headersToRedact;
        this.io = new IOUtils(this.context);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 8) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        this(context, chuckerCollector, l, set);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength) {
        this(context, collector, maxContentLength, null, 8, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector) {
        this(context, collector, 0L, null, 12, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context) {
        this(context, null, 0L, null, 14, null);
    }

    static {
        Companion = new Companion(null);
        UTF8 = Charset.forName("UTF-8");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Companion;", "", "()V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

